"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// electron/app-bridge.ts
var app_bridge_exports = {};
__export(app_bridge_exports, {
  default: () => app_bridge_default
});
module.exports = __toCommonJS(app_bridge_exports);
var import_electron = require("electron");
var appointmentsApi = {
  getAppointment: (id) => import_electron.ipcRenderer.invoke("appointment:get", id),
  getTimeline: (forceRefresh) => import_electron.ipcRenderer.invoke("appointment:timeline", forceRefresh)
};
var appointmentsPopupApi = {
  showInfoPopup: (appointmentId, appointmentDurationInPercent, offsetInPercent) => import_electron.ipcRenderer.send("appointment:show-info-popup", appointmentId, appointmentDurationInPercent, offsetInPercent),
  onInfoPopupClosed: (callback) => import_electron.ipcRenderer.on("appointment:info-popup-closed", () => callback()),
  setInfoPopupHeight: (height) => import_electron.ipcRenderer.send("appointment:set-popup-height", height)
};
var debugApi = {
  log: (...args) => import_electron.ipcRenderer.send("debug:log", ...args)
};
var identityApi = {
  setIdentity: (identity) => import_electron.ipcRenderer.send("app:set-credentials", identity),
  forgetIdentity: () => import_electron.ipcRenderer.send("app:forget-identity"),
  getExchangeInfo: () => import_electron.ipcRenderer.invoke("app:get-exchange-info")
};
var notesApi = {
  openNotesFolder: () => import_electron.ipcRenderer.send("notes:open-folder"),
  openNotesFile: (info) => import_electron.ipcRenderer.send("notes:open-file", info),
  getNotes: (info) => import_electron.ipcRenderer.invoke("notes:get-by-info", info),
  setNotes: (info, content) => import_electron.ipcRenderer.invoke("notes:set-by-info", info, content)
};
var settingsApi = {
  closeSettings: () => import_electron.ipcRenderer.send("app:close-settings"),
  showSettings: () => import_electron.ipcRenderer.send("app:show-settings")
};
var themesApi = {
  getAvailableThemes: () => import_electron.ipcRenderer.invoke("themes:get-all"),
  editThemesFile: () => import_electron.ipcRenderer.send("themes:edit-themes-file"),
  notifyThemeUpdate: (newTheme) => import_electron.ipcRenderer.send("themes:did-update", newTheme),
  onThemeUpdated: (callback) => import_electron.ipcRenderer.on("themes:did-update", (_, newTheme) => callback(newTheme))
};
var electronApi = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, appointmentsApi), appointmentsPopupApi), debugApi), identityApi), notesApi), settingsApi), themesApi);
import_electron.contextBridge.exposeInMainWorld("app", electronApi);
var app_bridge_default = electronApi;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
