"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverResponseCollection = void 0;
const AutodiscoverResponse_1 = require("./Responses/AutodiscoverResponse");
/**
 * Represents a collection of responses to a call to the Autodiscover service.
 * @typeparam {TResponse} The type of the responses in the collection.
 */
class AutodiscoverResponseCollection extends AutodiscoverResponse_1.AutodiscoverResponse {
    /**
     * @internal Initializes a new instance of the **AutodiscoverResponseCollection<TResponse>** class.
     */
    constructor() {
        super();
        this.responses = [];
    }
    /**
     * Gets the number of responses in the collection.
     */
    get Count() {
        return this.responses.length;
    }
    ;
    /**
     * @internal Gets the responses list.
     */
    get Responses() {
        return this.responses;
    }
    /**
     * Gets the response at the specified index.
     *
     * @param   {number}   index   Index.
     * @returns {TResponse} TResponse at the index
     */
    __thisIndexer(index) {
        return this.Responses[index];
    }
    /**
     * Gets an enumerator that iterates through the elements of the collection.
     *
     * @return  {TResponse[]}      An IEnumerator for the collection.
     */
    GetEnumerator() {
        return this.responses;
    }
    /**
     * @internal Loads response from XML.
     *
     * @param   {any} responseObject  Json Object converted from XML.
     */
    LoadFromXmlJsObject(responseObject) {
        var element = this.GetResponseCollectionXmlElementName();
        super.LoadFromXmlJsObject(responseObject);
        this.LoadResponseCollectionFromXmlJsObject(responseObject[element]);
    }
    /**
     * Loads the response collection from XML.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     */
    LoadResponseCollectionFromXmlJsObject(jsObject) {
        var element = this.GetResponseInstanceXmlElementName();
        var responses = undefined;
        if (Array.isArray(jsObject[element]))
            responses = jsObject[element];
        else
            responses = [jsObject[element]];
        for (var i = 0; i < responses.length; i++) {
            var response = this.CreateResponseInstance();
            response.LoadFromXmlJsObject(responses[i]);
            this.Responses.push(response);
        }
    }
}
exports.AutodiscoverResponseCollection = AutodiscoverResponseCollection;
//# sourceMappingURL=AutodiscoverResponseCollection.js.map