"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainSettingError = void 0;
const AutodiscoverErrorCode_1 = require("../Enumerations/AutodiscoverErrorCode");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents an error from a GetDomainSettings request.
 * @sealed
 */
class DomainSettingError {
    /**
     * @internal Initializes a new instance of the **DomainSettingError** class.
     */
    constructor() {
    }
    /**
     * Gets the error code.
     */
    get ErrorCode() {
        return this.errorCode;
    }
    /**
     * Gets the error message.
     */
    get ErrorMessage() {
        return this.errorMessage;
    }
    /**
     * Gets the name of the setting.
     */
    get SettingName() {
        return this.settingName;
    }
    /**
     * @internal Loads settings error from XML jsObject.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     */
    LoadFromXmlJsObject(jsObject) {
        const errorstring = jsObject[XmlElementNames_1.XmlElementNames.ErrorCode];
        this.errorCode = AutodiscoverErrorCode_1.AutodiscoverErrorCode[errorstring] || AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError;
        this.errorMessage = jsObject[XmlElementNames_1.XmlElementNames.ErrorMessage] || null;
        this.settingName = jsObject[XmlElementNames_1.XmlElementNames.SettingName] || null;
    }
}
exports.DomainSettingError = DomainSettingError;
//# sourceMappingURL=DomainSettingError.js.map