"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverRequest = void 0;
const AutodiscoverErrorCode_1 = require("../../Enumerations/AutodiscoverErrorCode");
const AutodiscoverResponseException_1 = require("../../Exceptions/AutodiscoverResponseException");
const EwsLogging_1 = require("../../Core/EwsLogging");
const EwsServiceXmlWriter_1 = require("../../Core/EwsServiceXmlWriter");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const EwsXmlReader_1 = require("../../Core/EwsXmlReader");
const ExchangeServerInfo_1 = require("../../Core/ExchangeServerInfo");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceResponse_1 = require("../../Core/Responses/ServiceResponse");
const ServiceResponseException_1 = require("../../Exceptions/ServiceResponseException");
const SoapFaultDetails_1 = require("../../Misc/SoapFaultDetails");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
/**
 * @internal Represents the base class for all requested made to the Autodiscover service.
 */
class AutodiscoverRequest {
    /**
     * @internal Initializes a new instance of the **AutodiscoverRequest** class.
     *
     * @param   {AutodiscoverService}   service   Autodiscover service associated with this request.
     * @param   {Uri}                   url       URL of Autodiscover service.
     */
    constructor(service, url) {
        this.url = null;
        this.service = service;
        this.url = url;
    }
    /**
     * @internal Gets the URL.
     */
    get Service() {
        return this.service;
    }
    /**
     * @internal Gets the service.
     */
    get Url() {
        return this.url;
    }
    CreateRedirectionResponse(httpWebResponse /*IEwsHttpWebResponse*/) {
        //string location = httpWebResponse.Headers[System.Net.HttpResponseHeader.Location];
        //    if (!string.IsNullOrEmpty(location)) {
        //        try {
        //            Uri redirectionUri = new Uri(this.Url, location);
        //            if ((redirectionUri.Scheme == Uri.UriSchemeHttp) || (redirectionUri.Scheme == Uri.UriSchemeHttps)) {
        //                AutodiscoverResponse response = this.CreateServiceResponse();
        //                response.ErrorCode = AutodiscoverErrorCode.RedirectUrl;
        //                response.RedirectionUrl = redirectionUri;
        //                return response;
        //            }
        //            this.Service.TraceMessage(
        //                TraceFlags.AutodiscoverConfiguration,
        //                string.Format("Invalid redirection URL '{0}' returned by Autodiscover service.", redirectionUri));
        //        }
        //        catch (UriFormatException) {
        //            this.Service.TraceMessage(
        //                TraceFlags.AutodiscoverConfiguration,
        //                string.Format("Invalid redirection location '{0}' returned by Autodiscover service.", location));
        //        }
        //    }
        //    else {
        //        this.Service.TraceMessage(
        //            TraceFlags.AutodiscoverConfiguration,
        //            "Redirection response returned by Autodiscover service without redirection location.");
        //    }
        return null;
    }
    GetResponseStream(response /*IEwsHttpWebResponse*/) {
        //string contentEncoding = response.ContentEncoding;
        //Stream responseStream = response.GetResponseStream();
        //if (contentEncoding.ToLowerInvariant().Contains("gzip")) {
        //    return new GZipStream(responseStream, CompressionMode.Decompress);
        //}
        //else if (contentEncoding.ToLowerInvariant().Contains("deflate")) {
        //    return new DeflateStream(responseStream, CompressionMode.Decompress);
        //}
        //else {
        //    return responseStream;
        //}
    }
    /**
     * Executes this instance.
     *
     * @return  {Promise<AutodiscoverResponse>}      [description]
     */
    InternalExecute() {
        return __awaiter(this, void 0, void 0, function* () {
            this.Validate();
            try {
                var writer = new EwsServiceXmlWriter_1.EwsServiceXmlWriter(this.service);
                this.WriteSoapRequest(this.url, writer);
                if (!this.service)
                    throw new Error("Missing Service");
                var cc = writer.GetXML();
                var xhrOptions = {
                    type: "POST",
                    data: cc,
                    url: this.url.ToString(),
                    headers: { "Content-Type": "text/xml" },
                };
                //If not set, credentials might come from custom XHRApi
                if (this.service.Credentials) {
                    this.service.Credentials.PrepareWebRequest(xhrOptions);
                }
                EwsLogging_1.EwsLogging.DebugLog("sending ews request");
                EwsLogging_1.EwsLogging.DebugLog(Object.assign(Object.assign({}, xhrOptions), { headers: Object.assign(Object.assign({}, xhrOptions.headers), { Authorization: "REDACTED" }) }), true);
                const xhrResponse = yield this.service.XHRApi.xhr(xhrOptions);
                const ewsXmlReader = new EwsXmlReader_1.EwsXmlReader(xhrResponse.responseText || xhrResponse.response);
                const responseObject = ewsXmlReader.JsObject;
                EwsLogging_1.EwsLogging.DebugLog(responseObject, true);
                if (xhrResponse.status == 200) {
                    EwsLogging_1.EwsLogging.DebugLog(xhrResponse, true);
                    this.ReadSoapHeader(responseObject[XmlElementNames_1.XmlElementNames.SOAPHeaderElementName]);
                    var response = this.ReadSoapBody(responseObject);
                    if (response.ErrorCode == AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError) {
                        //todo: passon to successDelegate
                        //return response;
                    }
                    else {
                        throw new AutodiscoverResponseException_1.AutodiscoverResponseException(response.ErrorCode, response.ErrorMessage);
                    }
                }
                else {
                    EwsLogging_1.EwsLogging.Log("status !== 200", true, true);
                    EwsLogging_1.EwsLogging.Log(xhrResponse.response, true, true);
                    EwsLogging_1.EwsLogging.Log(ewsXmlReader, true, true);
                }
                return response || xhrResponse.responseText || xhrResponse.response;
            }
            catch (resperr) {
                let exception;
                try {
                    this.ProcessWebException(resperr);
                }
                catch (exc) {
                    exception = exc;
                }
                throw (exception || resperr.responseText || resperr.response);
            }
        });
    }
    /**
     * @internal Determines whether response is a redirection.
     *
     * @param   {XMLHttpRequest}    httpWebResponse   The HTTP web response.
     * @return  {boolean}           True if redirection response.
     */
    static IsRedirectionResponse(httpWebResponse) {
        return (httpWebResponse.status == 302 /* Redirect */) ||
            (httpWebResponse.status == 301 /* Moved */) ||
            (httpWebResponse.status == 307 /* RedirectKeepVerb */) ||
            (httpWebResponse.status == 303 /* RedirectMethod */);
    }
    /**
     * @internal Loads response from XML.
     *
     * @param   {any} responseObject  Json Object converted from XML.
     */
    LoadFromXmlJsObject(jsObject) {
        const elementName = this.GetResponseXmlElementName();
        const responseObject = jsObject[elementName];
        var response = this.CreateServiceResponse();
        response.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.Response]);
        return response;
    }
    /**
     * Processes the web exception.
     *
     * @param   {XMLHttpRequest}   webException   The web exception.
     */
    ProcessWebException(webException) {
        if (webException.response) {
            //IEwsHttpWebResponse httpWebResponse = this.Service.HttpWebRequestFactory.CreateExceptionResponse(webException);
            var soapFaultDetails = null;
            if (webException.status == 500 /* InternalServerError */) {
                // If tracing is enabled, we read the entire response into a MemoryStream so that we
                // can pass it along to the ITraceListener. Then we parse the response from the
                // MemoryStream.
                //if (this.Service.IsTraceEnabledFor(TraceFlags.AutodiscoverRequest)) {
                //using(MemoryStream memoryStream = new MemoryStream())
                //{
                //    using(Stream serviceResponseStream = AutodiscoverRequest.GetResponseStream(httpWebResponse))
                //    {
                //        // Copy response to in-memory stream and reset position to start.
                //        EwsUtilities.CopyStream(serviceResponseStream, memoryStream);
                //        memoryStream.Position = 0;
                //    }
                //todo implement tracing to base class.
                //this.Service.TraceResponse(httpWebResponse, memoryStream);
                //var reader = new EwsXmlReader(webException.responseText);
                //soapFaultDetails = this.ReadSoapFault(reader);
                //}
                //}
                //else {
                //    using(Stream stream = AutodiscoverRequest.GetResponseStream(httpWebResponse))
                //    {
                //        EwsXmlReader reader = new EwsXmlReader(stream);
                //        soapFaultDetails = this.ReadSoapFault(reader);
                //    }
                //}
                var reader = new EwsXmlReader_1.EwsXmlReader(webException.responseText || webException.response);
                soapFaultDetails = this.ReadSoapFault(reader.JsObject);
                if (soapFaultDetails) {
                    //todo: implement soap fault error throw
                    throw new ServiceResponseException_1.ServiceResponseException(new ServiceResponse_1.ServiceResponse(soapFaultDetails));
                }
            }
            else {
                //todo: fix this
                this.Service.ProcessHttpErrorResponse(webException, webException);
            }
        }
    }
    /**
     * @internal Read SOAP body.
     *
     * @param   {object}   jsObject   EwsXmlReader
     * @returns {AutodiscoverResponse}  AutodiscoverResponse
     */
    ReadSoapBody(jsObject) {
        var responses = this.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.SOAPBodyElementName]);
        return responses;
    }
    /**
     * Reads the SOAP fault.
     *
     * @param   {any}   jsObject   The reader.
     * @return  {SoapFaultDetails}  SOAP fault details.
     */
    ReadSoapFault(jsObject) {
        var soapFaultDetails = undefined;
        if (jsObject && jsObject[XmlElementNames_1.XmlElementNames.SOAPBodyElementName]) {
            var obj = jsObject[XmlElementNames_1.XmlElementNames.SOAPBodyElementName];
            if (obj[XmlElementNames_1.XmlElementNames.SOAPFaultElementName])
                soapFaultDetails = SoapFaultDetails_1.SoapFaultDetails.Parse(obj[XmlElementNames_1.XmlElementNames.SOAPFaultElementName]);
        }
        return soapFaultDetails;
        //skipped xml section, using Json only.
        //////try {
        //////    // WCF may not generate an XML declaration.
        //////    reader.Read();
        //////    //if (reader.NodeType == Node.  System.Xml.XmlNodeType.XmlDeclaration) {
        //////    //    reader.Read();
        //////    //}
        //////    if (reader.LocalName != XmlElementNames.SOAPEnvelopeElementName) {
        //////        return soapFaultDetails;
        //////    }
        //////    // Get the namespace URI from the envelope element and use it for the rest of the parsing.
        //////    // If it's not 1.1 or 1.2, we can't continue.
        //////    var soapNamespace: XmlNamespace = EwsUtilities.GetNamespaceFromUri(reader.NamespaceUri);
        //////    if (soapNamespace == XmlNamespace.NotSpecified) {
        //////        return soapFaultDetails;
        //////    }
        //////    reader.Read();
        //////    // Skip SOAP header.
        //////    if (reader.IsElement(soapNamespace, XmlElementNames.SOAPHeaderElementName)) {
        //////        do {
        //////            reader.Read();
        //////        }
        //////        while (reader.HasRecursiveParent(XmlElementNames.SOAPHeaderElementName));
        //////        // Queue up the next read
        //////        //reader.Read(); - no need with nodeiterator/treewalker as the node is already a body Node
        //////    }
        //////    // Parse the fault element contained within the SOAP body.
        //////    if (reader.IsElement(soapNamespace, XmlElementNames.SOAPBodyElementName)) {
        //////        do {
        //////            reader.Read();
        //////            // Parse Fault element
        //////            if (reader.IsElement(soapNamespace, XmlElementNames.SOAPFaultElementName)) {
        //////                soapFaultDetails = SoapFaultDetails.Parse(reader, soapNamespace);
        //////            }
        //////        }
        //////        while (reader.HasRecursiveParent(XmlElementNames.SOAPBodyElementName));
        //////    }
        //////}
        //////catch (XmlException) {
        //////    // If response doesn't contain a valid SOAP fault, just ignore exception and
        //////    // return null for SOAP fault details.
        //////}
        //////return soapFaultDetails;
    }
    /**
     * @internal Read SOAP headers.
     *
     * @param   {object}   reader   EwsXmlReader
     */
    ReadSoapHeader(jsobject) {
        this.service.ServerInfo = ExchangeServerInfo_1.ExchangeServerInfo.Parse(jsobject[XmlElementNames_1.XmlElementNames.ServerVersionInfo]);
    }
    /**
     * @internal Validates the request.
     */
    Validate() {
        this.Service.Validate();
    }
    /**
     * @internal Writes XML body.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteBodyToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, this.GetRequestXmlElementName());
        this.WriteAttributesToXml(writer);
        this.WriteElementsToXml(writer);
        writer.WriteEndElement(); // m:this.GetXmlElementName()
    }
    /**
     * @internal Write extra headers.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer
     */
    WriteExtraCustomSoapHeadersToXml(writer) { }
    /**
     * @internal Writes the autodiscover SOAP request.
     *
     * @param   {Uri}                   requestUrl   Request URL.
     * @param   {EwsServiceXmlWriter}   writer       The writer.
     */
    WriteSoapRequest(requestUrl, writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Soap, XmlElementNames_1.XmlElementNames.SOAPEnvelopeElementName);
        writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespacePrefix, EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespace);
        writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.WSAddressingNamespacePrefix, EwsUtilities_1.EwsUtilities.WSAddressingNamespace);
        writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.EwsXmlSchemaInstanceNamespacePrefix, EwsUtilities_1.EwsUtilities.EwsXmlSchemaInstanceNamespace);
        if (writer.RequireWSSecurityUtilityNamespace) {
            writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.WSSecurityUtilityNamespacePrefix, EwsUtilities_1.EwsUtilities.WSSecurityUtilityNamespace);
        }
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Soap, XmlElementNames_1.XmlElementNames.SOAPHeaderElementName);
        if (this.Service.Credentials != null) {
            this.Service.Credentials.EmitExtraSoapHeaderNamespaceAliases(writer);
        }
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.RequestedServerVersion, ExchangeVersion_1.ExchangeVersion[this.Service.RequestedServerVersion]);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.WSAddressing, XmlElementNames_1.XmlElementNames.Action, this.GetWsAddressingActionName());
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.WSAddressing, XmlElementNames_1.XmlElementNames.To, requestUrl.AbsoluteUri);
        this.WriteExtraCustomSoapHeadersToXml(writer);
        //if (this.Service.Credentials != null) {
        //    this.Service.Credentials.SerializeWSSecurityHeaders(writer.InternalWriter);
        //}
        //this.Service.DoOnSerializeCustomSoapHeaders(writer.InternalWriter);
        writer.WriteEndElement(); // soap:Header
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Soap, XmlElementNames_1.XmlElementNames.SOAPBodyElementName);
        this.WriteBodyToXml(writer);
        writer.WriteEndElement(); // soap:Body
        writer.WriteEndElement(); // soap:Envelope
        writer.Flush();
    }
}
exports.AutodiscoverRequest = AutodiscoverRequest;
//# sourceMappingURL=AutodiscoverRequest.js.map