"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverResponse = void 0;
const AutodiscoverErrorCode_1 = require("../../Enumerations/AutodiscoverErrorCode");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
/**
 * Represents the base class for all responses returned by the Autodiscover service.
 */
class AutodiscoverResponse {
    constructor() {
        this.errorCode = AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError;
    }
    /**
     * Gets the error code that was returned by the service.
     */
    get ErrorCode() {
        return this.errorCode;
    }
    /** @internal */
    set ErrorCode(value) {
        this.errorCode = value;
    }
    /**
     * Gets the error message that was returned by the service.
     */
    get ErrorMessage() {
        return this.errorMessage;
    }
    /** @internal */
    set ErrorMessage(value) {
        this.errorMessage = value;
    }
    /**
     * @internal Gets or sets the redirection URL.
     */
    get RedirectionUrl() {
        return this.redirectionUrl;
    }
    set RedirectionUrl(value) {
        this.redirectionUrl = value;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any} responseObject  Json Object converted from XML.
     */
    LoadFromXmlJsObject(jsObject) {
        var errorstring = jsObject[XmlElementNames_1.XmlElementNames.ErrorCode];
        this.errorCode = AutodiscoverErrorCode_1.AutodiscoverErrorCode[errorstring];
        var errmsg = jsObject[XmlElementNames_1.XmlElementNames.ErrorMessage];
        this.errorMessage = errmsg;
    }
}
exports.AutodiscoverResponse = AutodiscoverResponse;
//# sourceMappingURL=AutodiscoverResponse.js.map