"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDomainSettingsResponseCollection = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const AutodiscoverResponseCollection_1 = require("../AutodiscoverResponseCollection");
const GetDomainSettingsResponse_1 = require("./GetDomainSettingsResponse");
/**
 * Represents a collection of responses to GetDomainSettings
 * @sealed
 */
class GetDomainSettingsResponseCollection extends AutodiscoverResponseCollection_1.AutodiscoverResponseCollection {
    /**
     * Initializes a new instance of the **GetDomainSettingsResponseCollection<GetDomainSettingsResponse>** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Create a response instance.
     *
     * @return  {GetDomainSettingsResponse}      GetDomainSettingsResponse.
     */
    CreateResponseInstance() {
        return new GetDomainSettingsResponse_1.GetDomainSettingsResponse();
    }
    /**
     * @internal Gets the name of the response collection XML element.
     *
     * @return  {string}      Response collection XMl element name.
     */
    GetResponseCollectionXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DomainResponses;
    }
    /**
     * @internal Gets the name of the response instance XML element.
     *
     * @return  {string}      Response instance XMl element name.
     */
    GetResponseInstanceXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DomainResponse;
    }
}
exports.GetDomainSettingsResponseCollection = GetDomainSettingsResponseCollection;
//# sourceMappingURL=GetDomainSettingsResponseCollection.js.map