"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserSettingsResponseCollection = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const AutodiscoverResponseCollection_1 = require("../AutodiscoverResponseCollection");
const GetUserSettingsResponse_1 = require("./GetUserSettingsResponse");
/**
 * Represents a collection of responses to GetUserSettings
 * @sealed
 */
class GetUserSettingsResponseCollection extends AutodiscoverResponseCollection_1.AutodiscoverResponseCollection {
    /**
     * Initializes a new instance of the **GetUserSettingsResponseCollection<GetUserSettingsResponse>** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Create a response instance.
     *
     * @return  {GetUserSettingsResponse}      GetDomainSettingsResponse.
     */
    CreateResponseInstance() {
        return new GetUserSettingsResponse_1.GetUserSettingsResponse();
    }
    /**
     * @internal Gets the name of the response collection XML element.
     *
     * @return  {string}      Response collection XMl element name.
     */
    GetResponseCollectionXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UserResponses;
    }
    /**
     * @internal Gets the name of the response instance XML element.
     *
     * @return  {string}      Response instance XMl element name.
     */
    GetResponseInstanceXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UserResponse;
    }
}
exports.GetUserSettingsResponseCollection = GetUserSettingsResponseCollection;
//# sourceMappingURL=GetUserSettingsResponseCollection.js.map