"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserSettingError = void 0;
const AutodiscoverErrorCode_1 = require("../Enumerations/AutodiscoverErrorCode");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents an error from a GetUserSettings request.
 * @sealed
 */
class UserSettingError {
    constructor(errorCode = AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError, errorMessage = null, settingName = null) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.settingName = settingName;
    }
    /**
     * Gets the error code.
     */
    get ErrorCode() {
        return this.errorCode;
    }
    /** @internal */
    set ErrorCode(value) {
        this.errorCode = value;
    }
    /**
     * Gets the error message.
     */
    get ErrorMessage() {
        return this.errorMessage;
    }
    /** @internal */
    set ErrorMessage(value) {
        this.errorMessage = value;
    }
    /**
     * Gets the name of the setting.
     */
    get SettingName() {
        return this.settingName;
    }
    /** @internal */
    set SettingName(value) {
        this.settingName = value;
    }
    /**
     * @internal Loads settings error from XML jsObject.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     */
    LoadFromXmlJsObject(jsObject) {
        var errorstring = jsObject[XmlElementNames_1.XmlElementNames.ErrorCode];
        this.errorCode = AutodiscoverErrorCode_1.AutodiscoverErrorCode[errorstring] || AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError;
        this.errorMessage = jsObject[XmlElementNames_1.XmlElementNames.ErrorMessage] || null;
        this.settingName = jsObject[XmlElementNames_1.XmlElementNames.SettingName] || null;
    }
}
exports.UserSettingError = UserSettingError;
//# sourceMappingURL=UserSettingError.js.map