"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an AddressEntity object.
 */
class AddressEntity extends ExtractedEntity_1.ExtractedEntity {
    /**
     * Initializes a new instance of the **AddressEntity** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgAddress:
                    this.Address = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.AddressEntity = AddressEntity;
//# sourceMappingURL=AddressEntity.js.map