"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppointmentOccurrenceId = void 0;
const Strings_1 = require("../Strings");
const ArgumentException_1 = require("../Exceptions/ArgumentException");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const ItemId_1 = require("./ItemId");
class AppointmentOccurrenceId extends ItemId_1.ItemId {
    constructor(recurringMasterUniqueId, occurrenceIndex) {
        super(recurringMasterUniqueId);
        this.OccurrenceIndex = occurrenceIndex;
    }
    get OccurrenceIndex() {
        return this.occurrenceIndex;
    }
    set OccurrenceIndex(value) {
        if (value < 1) {
            throw new ArgumentException_1.ArgumentException(Strings_1.Strings.OccurrenceIndexMustBeGreaterThanZero);
        }
        this.occurrenceIndex = value;
    }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.OccurrenceItemId; }
    InternalToJson(service) { throw new Error("AppointmentOccurrenceId.ts - InternalToJson : Not implemented."); }
    /**@internal */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.RecurringMasterId, this.UniqueId);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.InstanceIndex, this.OccurrenceIndex);
    }
}
exports.AppointmentOccurrenceId = AppointmentOccurrenceId;
//# sourceMappingURL=AppointmentOccurrenceId.js.map