"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Attendee = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const MeetingResponseType_1 = require("../Enumerations/MeetingResponseType");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const EmailAddress_1 = require("./EmailAddress");
/**
 * Represents an attendee to a meeting.
 */
class Attendee extends EmailAddress_1.EmailAddress {
    constructor(smtpAddressOrNameOrMailbox, smtpAddress, routingType) {
        switch (arguments.length) {
            case 1:
                super(smtpAddressOrNameOrMailbox);
                if (typeof smtpAddressOrNameOrMailbox === 'string') {
                    EwsUtilities_1.EwsUtilities.ValidateParam(smtpAddressOrNameOrMailbox, "smtpAddress");
                }
                break;
            case 2:
                super(smtpAddressOrNameOrMailbox, smtpAddress);
                break;
            case 3:
                super(smtpAddressOrNameOrMailbox, smtpAddress, routingType);
                break;
            default:
                super();
                break;
        }
        this.responseType = null;
        this.lastResponseTime = null;
    }
    /**
     * Gets the type of response the attendee gave to the meeting invitation it received.
     */
    get ResponseType() {
        return this.responseType;
    }
    /**
     * Gets the date and time when the attendee last responded to a meeting invitation or update.
     */
    get LastResponseTime() {
        return this.lastResponseTime;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            if (key.indexOf("__") === 0) {
                continue;
            }
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Mailbox:
                    super.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ResponseType:
                    this.responseType = MeetingResponseType_1.MeetingResponseType[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.LastResponseTime:
                    this.lastResponseTime = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(this.Namespace, XmlElementNames_1.XmlElementNames.Mailbox);
        super.WriteElementsToXml(writer);
        writer.WriteEndElement();
    }
}
exports.Attendee = Attendee;
//# sourceMappingURL=Attendee.js.map