"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttendeeCollection = void 0;
const ArgumentException_1 = require("../Exceptions/ArgumentException");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const Strings_1 = require("../Strings");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const Attendee_1 = require("./Attendee");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of attendees.
 */
class AttendeeCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **AttendeeCollection** class.
     */
    constructor() {
        super();
    }
    Add(nameOrSmtpAddressOrAttendee, smtpAddress) {
        let argsLength = arguments.length;
        let attendee = nameOrSmtpAddressOrAttendee;
        if (argsLength == 1) {
            if (typeof nameOrSmtpAddressOrAttendee === 'string') {
                attendee = new Attendee_1.Attendee(nameOrSmtpAddressOrAttendee);
            }
            else {
                attendee = nameOrSmtpAddressOrAttendee;
            }
        }
        if (argsLength === 2) {
            attendee = new Attendee_1.Attendee(nameOrSmtpAddressOrAttendee, smtpAddress);
        }
        this.InternalAdd(attendee);
        return attendee;
    }
    /**
     * Clears the collection.
     */
    Clear() {
        this.InternalClear();
    }
    /**
     * @internal Creates an Attendee object from an XML element name.
     *
     * @param   {string}   xmlElementName   The XML element name from which to create the attendee.
     * @return  {Attendee}      An Attendee object.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == XmlElementNames_1.XmlElementNames.Attendee) {
            return new Attendee_1.Attendee();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {Attendee}      [description]
     */
    CreateDefaultComplexProperty() { return new Attendee_1.Attendee(); }
    /**
     * @internal Retrieves the XML element name corresponding to the provided Attendee object.
     *
     * @param   {Attendee}   attendee   The Attendee object from which to determine the XML element name.
     * @return  {string}        The XML element name corresponding to the provided Attendee object.
     */
    GetCollectionItemXmlElementName(attendee) { return XmlElementNames_1.XmlElementNames.Attendee; }
    /**
     * Removes an attendee from the collection.
     *
     * @param   {Attendee}   attendee   The attendee to remove.
     * @return  {boolean}              True if the attendee was successfully removed from the collection, false otherwise.
     */
    Remove(attendee) {
        EwsUtilities_1.EwsUtilities.ValidateParam(attendee, "attendee");
        return this.InternalRemove(attendee);
    }
    /**
     * Removes an attendee from the collection.
     *
     * @param   {number}   index   The index of the attendee to remove.
     */
    RemoveAt(index) {
        if (index < 0 || index >= this.Count) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("index", Strings_1.Strings.IndexIsOutOfRange);
        }
        this.InternalRemoveAt(index);
    }
}
exports.AttendeeCollection = AttendeeCollection;
//# sourceMappingURL=AttendeeCollection.js.map