"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangeHighlights = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Encapsulates information on the changehighlights of a meeting request.
 *
 * @sealed
 */
class ChangeHighlights extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **ChangeHighlights** class.
     */
    constructor() {
        super();
        this.hasLocationChanged = false;
        this.location = null;
        this.hasStartTimeChanged = false;
        this.start = null;
        this.hasEndTimeChanged = false;
        this.end = null;
    }
    /**
     * Gets a value indicating whether the location has changed.
     */
    get HasLocationChanged() {
        return this.hasLocationChanged;
    }
    /**
     * Gets the old location
     */
    get Location() {
        return this.location;
    }
    /**
     * Gets a value indicating whether the the start time has changed.
     */
    get HasStartTimeChanged() {
        return this.hasStartTimeChanged;
    }
    /**
     * Gets the old start date and time of the meeting.
     */
    get Start() {
        return this.start;
    }
    /**
     * Gets a value indicating whether the the end time has changed.
     */
    get HasEndTimeChanged() {
        return this.hasEndTimeChanged;
    }
    /**
     * Gets the old end date and time of the meeting.
     */
    get End() {
        return this.end;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.HasLocationChanged:
                    this.hasLocationChanged = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Location:
                    this.location = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.HasStartTimeChanged:
                    this.hasStartTimeChanged = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Start:
                    this.start = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.HasEndTimeChanged:
                    this.hasEndTimeChanged = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.End:
                    this.end = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.ChangeHighlights = ChangeHighlights;
//# sourceMappingURL=ChangeHighlights.js.map