"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ContactEntity_1 = require("./ContactEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of ContactEntity objects.
 */
class ContactEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((entity) => { this.InternalAdd(entity); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}                xmlElementName   Name of the XML element.
     * @return  {ContactEntity}     ContactEntity.
     */
    CreateComplexProperty(xmlElementName) { return new ContactEntity_1.ContactEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {ContactEntity}      ContactEntity.
     */
    CreateDefaultComplexProperty() { return new ContactEntity_1.ContactEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {ContactEntity}     complexProperty   The complex property.
     * @return  {string}                XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgContact; }
}
exports.ContactEntityCollection = ContactEntityCollection;
//# sourceMappingURL=ContactEntityCollection.js.map