"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationId = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ServiceId_1 = require("./ServiceId");
/**
 * Represents the Id of a Conversation.
 */
class ConversationId extends ServiceId_1.ServiceId {
    constructor(uniqueId) {
        arguments.length === 0 ? super() : super(uniqueId);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.ConversationId;
    }
    /**
     * Gets a string representation of the Conversation Id.
     *
     * @return  {string}      The string representation of the conversation id.
     */
    ToString() {
        // We have ignored the change key portion
        return this.UniqueId;
    }
    toString() {
        return this.ToString();
    }
}
exports.ConversationId = ConversationId;
//# sourceMappingURL=ConversationId.js.map