"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationRequest = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 *
 *
 * @sealed
 */
class ConversationRequest extends ComplexProperty_1.ComplexProperty {
    constructor(conversationId = null, syncState = null) {
        super();
        this.ConversationId = conversationId;
        this.SyncState = syncState;
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.ConversationId, "ConversationId");
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer           The writer.
     * @param   {string}                xmlElementName   Name of the XML element.
     */
    WriteToXml(writer, xmlElementName) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, xmlElementName);
        this.ConversationId.WriteToXml(writer);
        if (this.SyncState != null) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SyncState, this.SyncState);
        }
        writer.WriteEndElement();
    }
}
exports.ConversationRequest = ConversationRequest;
//# sourceMappingURL=ConversationRequest.js.map