"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationResponse = void 0;
const ConversationId_1 = require("./ConversationId");
const ConversationNodeCollection_1 = require("./ConversationNodeCollection");
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 *
 *
 * @sealed
 */
class ConversationResponse extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **ConversationResponse** class.
     *
     * @param   {PropertySet}   propertySet   The property set.
     */
    constructor(propertySet) {
        super();
        /**
         * Property set used to fetch items in the conversation.
         */
        this.propertySet = null;
        /**
         * Gets the conversation id.
         *
         * internal set
         */
        this.ConversationId = null;
        /**
         * Gets the sync state.
         *
         * internal set
         */
        this.SyncState = null;
        /**
         * Gets the conversation nodes.
         *
         * internal set
         */
        this.ConversationNodes = null;
        this.propertySet = propertySet;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        this.ConversationId = new ConversationId_1.ConversationId();
        this.ConversationId.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.ConversationId], service);
        if (jsObject[XmlElementNames_1.XmlElementNames.SyncState]) {
            this.SyncState = jsObject[XmlElementNames_1.XmlElementNames.SyncState];
        }
        this.ConversationNodes = new ConversationNodeCollection_1.ConversationNodeCollection(this.propertySet);
        if (jsObject[XmlElementNames_1.XmlElementNames.ConversationNodes]) {
            this.ConversationNodes.LoadFromXmlJsObject(EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.ConversationNodes], XmlElementNames_1.XmlElementNames.ConversationNode), service);
        }
    }
}
exports.ConversationResponse = ConversationResponse;
//# sourceMappingURL=ConversationResponse.js.map