"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletedOccurrenceInfoCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const DeletedOccurrenceInfo_1 = require("./DeletedOccurrenceInfo");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of deleted occurrence objects.
 */
class DeletedOccurrenceInfoCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **OccurrenceInfoCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}   xmlElementName   Name of the XML element.
     * @return  {DeletedOccurrenceInfo}     OccurenceInfo instance.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == XmlElementNames_1.XmlElementNames.DeletedOccurrence) {
            return new DeletedOccurrenceInfo_1.DeletedOccurrenceInfo();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {DeletedOccurrenceInfo}     Default OccurenceInfo instance.
     */
    CreateDefaultComplexProperty() { return new DeletedOccurrenceInfo_1.DeletedOccurrenceInfo(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {DeletedOccurrenceInfo}   complexProperty   The complex property.
     * @return  {string}        XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.Occurrence; }
}
exports.DeletedOccurrenceInfoCollection = DeletedOccurrenceInfoCollection;
//# sourceMappingURL=DeletedOccurrenceInfoCollection.js.map