"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddressCollection = void 0;
const ArgumentException_1 = require("../Exceptions/ArgumentException");
const EmailAddress_1 = require("./EmailAddress");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const Strings_1 = require("../Strings");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of e-mail addresses.
 */
class EmailAddressCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collectionItemXmlElementName) {
        super();
        /**
         * XML element name
         */
        this.collectionItemXmlElementName = null;
        this.collectionItemXmlElementName = collectionItemXmlElementName || XmlElementNames_1.XmlElementNames.Mailbox;
    }
    Add(nameOrSmtpAddressOrEmailAddress, smtpAddress) {
        let argsLength = arguments.length;
        let emailAddress = nameOrSmtpAddressOrEmailAddress;
        if (argsLength == 1) {
            if (typeof nameOrSmtpAddressOrEmailAddress === 'string') {
                emailAddress = new EmailAddress_1.EmailAddress(nameOrSmtpAddressOrEmailAddress);
            }
            else {
                emailAddress = nameOrSmtpAddressOrEmailAddress;
            }
        }
        if (argsLength === 2) {
            emailAddress = new EmailAddress_1.EmailAddress(nameOrSmtpAddressOrEmailAddress, smtpAddress);
        }
        this.InternalAdd(emailAddress);
        return emailAddress;
    }
    AddRange(emailOrSmtpAddresses) {
        for (let address of emailOrSmtpAddresses) {
            let emailAddress = address;
            if (typeof emailAddress === 'string') {
                emailAddress = new EmailAddress_1.EmailAddress(address);
            }
            this.InternalAdd(emailAddress);
        }
    }
    /**
     * Clears the collection.
     */
    Clear() { this.InternalClear(); }
    /**
     * @internal Creates an EmailAddress object from an XML element name.
     *
     * @param   {string}   xmlElementName   The XML element name from which to create the e-mail address.
     * @return  {EmailAddress}              An EmailAddress object.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == this.collectionItemXmlElementName) {
            return new EmailAddress_1.EmailAddress();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {EmailAddress}      default instance of EmailAddress
     */
    CreateDefaultComplexProperty() { return new EmailAddress_1.EmailAddress(); }
    /**
     * @internal Retrieves the XML element name corresponding to the provided EmailAddress object.
     *
     * @param   {EmailAddress}   emailAddress   The EmailAddress object from which to determine the XML element name.
     * @return  {string}        The XML element name corresponding to the provided EmailAddress object.
     */
    GetCollectionItemXmlElementName(emailAddress) { return this.collectionItemXmlElementName; }
    /**
     * Removes an e-mail address from the collection.
     *
     * @param   {EmailAddress}  emailAddress   The e-mail address to remove.
     * @return  {boolean}       True if the email address was successfully removed from the collection, false otherwise.
     */
    Remove(emailAddress) {
        EwsUtilities_1.EwsUtilities.ValidateParam(emailAddress, "emailAddress");
        return this.InternalRemove(emailAddress);
    }
    /**
     * Removes an e-mail address from the collection.
     *
     * @param   {number}   index   The index of the e-mail address to remove.
     */
    RemoveAt(index) {
        if (index < 0 || index >= this.Count) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("index", Strings_1.Strings.IndexIsOutOfRange);
        }
        this.InternalRemoveAt(index);
    }
    /**
     * @internal Determine whether we should write collection to XML or not.
     *
     * @return  {true}      Always true, even if the collection is empty.
     */
    ShouldWriteToRequest() { return true; }
}
exports.EmailAddressCollection = EmailAddressCollection;
//# sourceMappingURL=EmailAddressCollection.js.map