"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddressEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an EmailAddressEntity object.
 */
class EmailAddressEntity extends ExtractedEntity_1.ExtractedEntity {
    /**
     * @internal Initializes a new instance of the **EmailAddressEntity** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgEmailAddress:
                    this.EmailAddress = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.EmailAddressEntity = EmailAddressEntity;
//# sourceMappingURL=EmailAddressEntity.js.map