"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddressEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const EmailAddressEntity_1 = require("./EmailAddressEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of EmailAddressEntity objects.
 */
class EmailAddressEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((entity) => { this.InternalAdd(entity); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}                xmlElementName   Name of the XML element.
     * @return  {EmailAddressEntity}    EmailAddressEntity.
     */
    CreateComplexProperty(xmlElementName) { return new EmailAddressEntity_1.EmailAddressEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {EmailAddressEntity}      EmailAddressEntity.
     */
    CreateDefaultComplexProperty() { return new EmailAddressEntity_1.EmailAddressEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {EmailAddressEntity}    complexProperty   The complex property.
     * @return  {string}                XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgEmailAddress; }
}
exports.EmailAddressEntityCollection = EmailAddressEntityCollection;
//# sourceMappingURL=EmailAddressEntityCollection.js.map