"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailUserEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an EmailUserEntity object.
 */
class EmailUserEntity extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **EmailUserEntity** class.
     */
    constructor() {
        super();
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgName:
                    this.Name = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgUserId:
                    this.UserId = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.EmailUserEntity = EmailUserEntity;
//# sourceMappingURL=EmailUserEntity.js.map