"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtractedEntity = void 0;
const EmailPosition_1 = require("../Enumerations/EmailPosition");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an ExtractedEntity object.
 */
class ExtractedEntity extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **ExtractedEntity** class.
     */
    constructor() {
        super();
        /**
         * Gets the Position.
         */
        this.Position = EmailPosition_1.EmailPosition.LatestReply;
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.NlgEmailPosition]) {
            this.Position = EmailPosition_1.EmailPosition[jsObject[XmlElementNames_1.XmlElementNames.NlgEmailPosition]] || this.Position;
        }
        // for (let key in jsObject) {
        //     switch (key) {
        //         case XmlElementNames.NlgEmailPosition:
        //             this.Position = EmailPosition[<string>jsObject[key]] || this.Position;
        //             break;
        //         default:
        //             break;
        //     }
        // }
    }
}
exports.ExtractedEntity = ExtractedEntity;
//# sourceMappingURL=ExtractedEntity.js.map