"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Flag = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ItemFlagStatus_1 = require("../Enumerations/ItemFlagStatus");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Encapsulates information on the occurrence of a recurring appointment.
 */
class Flag extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **Flag** class.
     */
    constructor() {
        super();
        this.flagStatus = ItemFlagStatus_1.ItemFlagStatus.NotFlagged;
        this.startDate = null;
        this.dueDate = null;
        this.completeDate = null;
    }
    /**
     * Gets or sets the flag status.
     */
    get FlagStatus() {
        return this.flagStatus;
    }
    set FlagStatus(value) {
        this.SetFieldValue({ getValue: () => this.flagStatus, setValue: (updateValue) => { this.flagStatus = updateValue; } }, value);
    }
    /**
     * Gets the start date.
     */
    get StartDate() {
        return this.startDate;
    }
    set StartDate(value) {
        this.SetFieldValue({ getValue: () => this.startDate, setValue: (updateValue) => { this.startDate = updateValue; } }, value);
    }
    /**
     * Gets the due date.
     */
    get DueDate() {
        return this.dueDate;
    }
    set DueDate(value) {
        this.SetFieldValue({ getValue: () => this.dueDate, setValue: (updateValue) => { this.dueDate = updateValue; } }, value);
    }
    /**
     * Gets the complete date.
     */
    get CompleteDate() {
        return this.completeDate;
    }
    set CompleteDate(value) {
        this.SetFieldValue({ getValue: () => this.completeDate, setValue: (updateValue) => { this.completeDate = updateValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (var key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.FlagStatus:
                    this.flagStatus = ItemFlagStatus_1.ItemFlagStatus[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.StartDate:
                    this.startDate = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.DueDate:
                    this.dueDate = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.CompleteDate:
                    this.completeDate = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Validates this instance.
     */
    Validate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.flagStatus, "FlagStatus");
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FlagStatus, ItemFlagStatus_1.ItemFlagStatus[this.FlagStatus]);
        if (this.FlagStatus == ItemFlagStatus_1.ItemFlagStatus.Flagged && this.StartDate != null && this.DueDate != null) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.StartDate, this.StartDate);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DueDate, this.DueDate);
        }
        else if (this.FlagStatus == ItemFlagStatus_1.ItemFlagStatus.Complete && this.CompleteDate != null) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.CompleteDate, this.CompleteDate);
        }
    }
}
exports.Flag = Flag;
//# sourceMappingURL=Flag.js.map