"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupMember = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const ComplexProperty_1 = require("./ComplexProperty");
const EmailAddress_1 = require("./EmailAddress");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ItemId_1 = require("./ItemId");
const MailboxType_1 = require("../Enumerations/MailboxType");
const MemberStatus_1 = require("../Enumerations/MemberStatus");
const ServiceLocalException_1 = require("../Exceptions/ServiceLocalException");
const Strings_1 = require("../Strings");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
/**
 * Represents a group member
 * [RequiredServerVersion(ExchangeVersion.Exchange2010)] ** needs implementation
 */
class GroupMember extends ComplexProperty_1.ComplexProperty {
    constructor(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey, _3mbxTypeOrRoutingType) {
        super();
        /**
         * AddressInformation field.
         */
        this.addressInformation = null;
        // Key is assigned by server
        this.key = null;
        // Member status is calculated by server
        this.status = MemberStatus_1.MemberStatus.Unrecognized;
        let argsLength = arguments.length;
        if (argsLength == 1) {
            if (typeof _1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId === 'string') { // smtpAddress
                this.AddressInformation = new EmailAddress_1.EmailAddress(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId);
            }
            else if (_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId instanceof ItemId_1.ItemId) { // contactGroupId
                this.AddressInformation = new EmailAddress_1.EmailAddress(null, null, null, MailboxType_1.MailboxType.ContactGroup, _1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId);
            }
            else if (_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId instanceof GroupMember) { // contactGroupId
                EwsUtilities_1.EwsUtilities.ValidateParam(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, "member");
                this.AddressInformation = new EmailAddress_1.EmailAddress(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId.AddressInformation);
            }
            else {
                this.AddressInformation = new EmailAddress_1.EmailAddress(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId);
            }
        }
        if (argsLength === 2) {
            if (typeof _1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId === 'string') {
                if (typeof _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey === 'string') {
                    this.AddressInformation = new EmailAddress_1.EmailAddress(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey, EmailAddress_1.EmailAddress.SmtpRoutingType, MailboxType_1.MailboxType.OneOff);
                }
                else {
                    this.constructor_str_str_mbType(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, EmailAddress_1.EmailAddress.SmtpRoutingType, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey);
                }
            }
            else if (_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId instanceof ItemId_1.ItemId) {
                this.AddressInformation = new EmailAddress_1.EmailAddress(null, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey, // addressToLink
                null, MailboxType_1.MailboxType.Contact, _1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId); //contactId
            }
            else {
                let contact = _1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId;
                EwsUtilities_1.EwsUtilities.ValidateParam(contact, "contact");
                let emailAddress = contact.EmailAddresses[_2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey /* emailAddressKey */];
                this.AddressInformation = new EmailAddress_1.EmailAddress(emailAddress);
                this.addressInformation.Id = contact.Id;
            }
        }
        if (argsLength === 3) {
            if (typeof _3mbxTypeOrRoutingType === 'string') { // mailboxType
                this.AddressInformation = new EmailAddress_1.EmailAddress(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey, _3mbxTypeOrRoutingType, MailboxType_1.MailboxType.OneOff);
            }
            else {
                this.constructor_str_str_mbType(_1smtpOrCGIdOrAddrInfoOrMemberOrAddrOrNameOrContactOrCId, _2routingTypeOrMbxTypeOrAddressOrSmtpOrAddr2LinkOrEmailKey, _3mbxTypeOrRoutingType);
            }
        }
    }
    /**
     * ets the key of the member.
     */
    get Key() {
        return this.key;
    }
    /**
     * Gets the address information of the member.
     */
    get AddressInformation() {
        return this.addressInformation;
    }
    /**
     * @internal Sets the address information of the member.
     */
    set AddressInformation(value) {
        if (this.addressInformation !== null) {
            ExtensionMethods_1.ArrayHelper.RemoveEntry(this.addressInformation.OnChange, this.AddressInformationChanged);
        }
        this.addressInformation = value;
        if (this.addressInformation !== null) {
            this.addressInformation.OnChange.push(this.AddressInformationChanged.bind(this));
        }
    }
    /**
     * Gets the status of the member.
     */
    get Status() {
        return this.status;
    }
    //#region Constructor methods
    constructor_str_str_mbType(address, routingType, mailboxType) {
        switch (mailboxType) {
            case MailboxType_1.MailboxType.PublicGroup:
            case MailboxType_1.MailboxType.PublicFolder:
            case MailboxType_1.MailboxType.Mailbox:
            case MailboxType_1.MailboxType.Contact:
            case MailboxType_1.MailboxType.OneOff:
                this.AddressInformation = new EmailAddress_1.EmailAddress(null, address, routingType, mailboxType);
                break;
            default:
                throw new ServiceLocalException_1.ServiceLocalException(Strings_1.Strings.InvalidMailboxType);
        }
    }
    //#endregion
    /**
     * AddressInformation instance is changed.
     *
     * @param   {}   complexProperty   Changed property.
     */
    AddressInformationChanged(complexProperty) {
        this.Changed();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.Key:
                    this.key = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Status:
                    this.status = MemberStatus_1.MemberStatus[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.Mailbox:
                    this.AddressInformation = new EmailAddress_1.EmailAddress();
                    this.AddressInformation.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes the member key attribute to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        // if this.key is null or empty, writer skips the attribute
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Key, this.key);
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        // No need to write member Status back to server
        // Write only AddressInformation container element
        this.AddressInformation.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Mailbox, XmlNamespace_1.XmlNamespace.Types);
    }
}
exports.GroupMember = GroupMember;
//# sourceMappingURL=GroupMember.js.map