"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImAddressEntry = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ImAddressKey_1 = require("../Enumerations/ImAddressKey");
const DictionaryEntryProperty_1 = require("./DictionaryEntryProperty");
class ImAddressEntry extends DictionaryEntryProperty_1.DictionaryEntryProperty {
    constructor(key = ImAddressKey_1.ImAddressKey.ImAddress1, imAddress = null) {
        super(key);
        this.imAddress = null;
        this.keyType = ImAddressKey_1.ImAddressKey;
        this.imAddress = imAddress;
    }
    get ImAddress() {
        return this.imAddress;
    }
    set ImAddress(value) {
        this.SetFieldValue({ getValue: () => this.imAddress, setValue: (address) => { this.imAddress = address; } }, value);
    }
    LoadFromXmlJsObject(jsonProperty, service) {
        this.Key = ImAddressKey_1.ImAddressKey[jsonProperty[XmlAttributeNames_1.XmlAttributeNames.Key]];
        this.ImAddress = jsonProperty[XmlElementNames_1.XmlElementNames.Entry]; // ImAddress];//ElementValue becomes Same ElementName when it has attribute. 
    }
    /**@internal */
    WriteElementsToXml(writer) { writer.WriteValue(this.ImAddress, XmlElementNames_1.XmlElementNames.ImAddress); }
}
exports.ImAddressEntry = ImAddressEntry;
//# sourceMappingURL=ImAddressEntry.js.map