"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemCollection = void 0;
const ArgumentException_1 = require("../Exceptions/ArgumentException");
const ExtensionMethods_1 = require("../ExtensionMethods");
const ItemInfo_1 = require("../Core/ServiceObjects/Items/ItemInfo");
const Strings_1 = require("../Strings");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents a collection of items.
 */
class ItemCollection extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **ItemCollection** class.
     *
     */
    constructor() {
        super();
        this.__implements = ["ISelfValidate", "IJsonSerializable", "IEnumerable<TItem>", "IJsonCollectionDeserializer"];
        this.items = []; // System.Collections.Generic.List<T>;
    }
    /**
     * Gets the total number of items in the collection.
     */
    get Count() {
        return this.items.length;
    }
    /**
     * Gets the item at the specified index.
     *
     * @param   {number}   index   The zero-based index of the item to get.
     * @return  {TItem}     The item at the specified index.
     */
    _getItem(index) {
        if (index < 0 || index >= this.Count) {
            throw new ArgumentException_1.ArgumentOutOfRangeException("index", Strings_1.Strings.IndexIsOutOfRange);
        }
        return this.items[index];
    }
    GetEnumerator() { throw new Error("ItemCollection.ts - GetEnumerator : Not implemented."); } //wil be implementedfor ES6 later with yield
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        let collectionObj = undefined;
        if (ExtensionMethods_1.ArrayHelper.isArray(jsObject)) {
            collectionObj = jsObject;
        }
        else {
            collectionObj = [jsObject];
        }
        for (let entry of collectionObj) {
            let jsonServiceObject = entry;
            let item = (new ItemInfo_1.ItemInfo()).CreateEwsObjectFromXmlElementName(service, ExtensionMethods_1.TypeSystem.GetJsObjectTypeName(jsonServiceObject));
            item.LoadFromXmlJsObject(jsonServiceObject, service, true);
            this.items.push(item);
        }
    }
}
exports.ItemCollection = ItemCollection;
//# sourceMappingURL=ItemCollection.js.map