"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemId = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ServiceId_1 = require("./ServiceId");
/**
 * Represents the Id of an Exchange item.
 *
 * @class ItemId
 * @extends {ServiceId}
 */
class ItemId extends ServiceId_1.ServiceId {
    constructor(uniqueId) {
        if (arguments.length === 0) {
            super();
            return;
        }
        super(uniqueId);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.ItemId;
    }
}
exports.ItemId = ItemId;
//# sourceMappingURL=ItemId.js.map