"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mailbox = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents a mailbox reference.
 */
class Mailbox extends ComplexProperty_1.ComplexProperty {
    constructor(smtpAddressOrAddress = null, routingType = null) {
        super();
        this.Address = smtpAddressOrAddress;
        this.RoutingType = routingType;
    }
    /**
     * True if this instance is valid, false otherthise.
     *
     * @value   *true* if this instance is valid; otherwise, *false*.
     */
    get IsValid() {
        return !ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Address);
    }
    /**
     * Determines whether the specified  is equal to the current .
     *
     * @param   {any}   obj   The  to compare with the current .
     * @return  {boolean}       true if the specified  is equal to the current ; otherwise, false.
     *
     * @exception   {NullReferenceException}    The **obj** parameter is null.
     */
    Equals(obj) {
        if (this === obj) {
            return true;
        }
        else {
            var other = obj;
            if (!(other instanceof Mailbox)) {
                return false;
            }
            else if (((this.Address == null) && (other.Address == null)) ||
                ((this.Address != null) && this.Address === other.Address)) {
                return ((this.RoutingType == null) && (other.RoutingType == null)) ||
                    ((this.RoutingType != null) && this.RoutingType === other.RoutingType);
            }
            else {
                return false;
            }
        }
    }
    //GetHashCode(): number { throw new Error("Mailbox.ts - GetHashCode : Not implemented."); }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        super.InternalValidate();
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.Address, "address");
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.RoutingType, "routingType");
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsonProperty, service) {
        //debug:
        if (jsonProperty[XmlElementNames_1.XmlElementNames.EmailAddress]) {
            this.Address = jsonProperty[XmlElementNames_1.XmlElementNames.EmailAddress]; //.ReadAsString(XmlElementNames.EmailAddress);
        }
        if (jsonProperty[XmlElementNames_1.XmlElementNames.RoutingType]) {
            this.RoutingType = jsonProperty[XmlElementNames_1.XmlElementNames.RoutingType]; //.ReadAsString(XmlElementNames.RoutingType);
        }
    }
    /**
     * Returns a  that represents the current .
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() {
        if (!this.IsValid) {
            return ExtensionMethods_1.StringHelper.Empty;
        }
        else if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.RoutingType)) {
            return this.RoutingType + ":" + this.Address;
        }
        else {
            return this.Address;
        }
    }
    toString() {
        return this.ToString();
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.EmailAddress, this.Address);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.RoutingType, this.RoutingType);
    }
    /**
     * Get a string representation for using this instance in a search filter.
     * ISearchStringProvider.GetSearchString
     *
     * @return  {string}      String representation of instance.
     */
    GetSearchString() {
        return this.Address;
    }
}
exports.Mailbox = Mailbox;
//# sourceMappingURL=Mailbox.js.map