"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingSuggestion = void 0;
const EmailUserEntityCollection_1 = require("./EmailUserEntityCollection");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an MeetingSuggestion object.
 */
class MeetingSuggestion extends ExtractedEntity_1.ExtractedEntity {
    /**
     * @internal Initializes a new instance of the **MeetingSuggestion** class.
     */
    constructor() {
        super();
        /**
         * Gets the meeting suggestion Attendees.
         */
        this.Attendees = null;
        /**
         * Gets the meeting suggestion Location.
         */
        this.Location = null;
        /**
         * Gets the meeting suggestion Subject.
         */
        this.Subject = null;
        /**
         * Gets the meeting suggestion MeetingString.
         */
        this.MeetingString = null;
        /**
         * Gets the meeting suggestion StartTime.
         */
        this.StartTime = null;
        /**
         * Gets the meeting suggestion EndTime.
         */
        this.EndTime = null;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgAttendees:
                    this.Attendees = new EmailUserEntityCollection_1.EmailUserEntityCollection();
                    this.Attendees.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgLocation:
                    this.Location = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgSubject:
                    this.Subject = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgMeetingString:
                    this.MeetingString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgStartTime:
                    this.StartTime = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgEndTime:
                    this.EndTime = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.MeetingSuggestion = MeetingSuggestion;
//# sourceMappingURL=MeetingSuggestion.js.map