"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingSuggestionCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const MeetingSuggestion_1 = require("./MeetingSuggestion");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of MeetingSuggestion objects.
 */
class MeetingSuggestionCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((suggestion) => { this.InternalAdd(suggestion); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}                xmlElementName   Name of the XML element.
     * @return  {MeetingSuggestion}     MeetingSuggestion.
     */
    CreateComplexProperty(xmlElementName) { return new MeetingSuggestion_1.MeetingSuggestion(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {MeetingSuggestion}      MeetingSuggestion.
     */
    CreateDefaultComplexProperty() { return new MeetingSuggestion_1.MeetingSuggestion(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {MeetingSuggestion}     complexProperty   The complex property.
     * @return  {string}                XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgMeetingSuggestion; }
}
exports.MeetingSuggestionCollection = MeetingSuggestionCollection;
//# sourceMappingURL=MeetingSuggestionCollection.js.map