"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageBody = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const BodyType_1 = require("../Enumerations/BodyType");
const ExtensionMethods_1 = require("../ExtensionMethods");
const ComplexProperty_1 = require("./ComplexProperty");
const EwsLogging_1 = require("../Core/EwsLogging");
class MessageBody extends ComplexProperty_1.ComplexProperty {
    constructor(bodyTypeOrText, text) {
        super();
        this.bodyType = 0;
        this.text = null;
        var argslength = arguments.length;
        if (argslength === 0) {
            return;
        }
        var bodyType = BodyType_1.BodyType.HTML;
        var strText = text;
        if (argslength === 1 && typeof bodyTypeOrText === "string") {
            strText = bodyTypeOrText;
        }
        if (argslength === 2 && typeof bodyTypeOrText === "number") {
            bodyType = bodyTypeOrText;
        }
        this.bodyType = bodyType;
        this.text = strText;
    }
    get BodyType() {
        return this.bodyType;
    }
    set BodyType(value) {
        this.SetFieldValue({ getValue: () => this.bodyType, setValue: (bodytype) => this.bodyType = bodytype }, value);
    }
    get Text() {
        return this.text;
    }
    set Text(value) {
        this.SetFieldValue({ getValue: () => this.text, setValue: (txt) => this.text = txt }, value);
    }
    LoadFromXmlJsObject(jsObject, service) {
        for (var key in jsObject) {
            if (key.indexOf("__") === 0) {
                continue;
            }
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.BodyType:
                    this.bodyType = BodyType_1.BodyType[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.Body: //info - Body Element text - custom parser in ews-javascript-api. 
                case XmlElementNames_1.XmlElementNames.TextBody: //info - TextBody Element text - custom parser in ews-javascript-api. 
                    this.text = jsObject[key];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.IsTruncated:
                    //ref: IsTruncated not captured 
                    break;
                default:
                    //debugger;//check exact name of body element
                    EwsLogging_1.EwsLogging.Log(`MessageBody->LoadFromXmlJsObject : element ${key} is skipped, open issue to fix this. `, true);
                    break;
            }
        }
    }
    /**@internal */
    ReadAttributesFromXmlJsObject(reader) { throw new Error("MessageBody.ts - ReadAttributesFromXml : Not implemented. - should not be called"); }
    /**@internal */
    ReadTextValueFromXmlJsObject(reader) { throw new Error("MessageBody.ts - ReadTextValueFromXml : Not implemented. - should not be called"); }
    ToString() { return (this.Text == null) ? ExtensionMethods_1.StringHelper.Empty : this.Text; }
    /**@internal */
    WriteAttributesToXml(writer) { writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.BodyType, BodyType_1.BodyType[this.BodyType]); }
    /**@internal */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Text)) {
            writer.WriteValue(this.Text, XmlElementNames_1.XmlElementNames.Body);
        }
    }
}
exports.MessageBody = MessageBody;
//# sourceMappingURL=MessageBody.js.map