"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MimeContent = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const MimeContentBase_1 = require("./MimeContentBase");
/**
 * Represents the MIME content of an item.
 */
class MimeContent extends MimeContentBase_1.MimeContentBase {
    constructor(characterSet = null, content = null) {
        super();
        this.CharacterSet = characterSet;
        this.Content = content;
        this.xmlElementName = XmlElementNames_1.XmlElementNames.MimeContent;
    }
    /**
     * Returns a **String** that represents the current **Object**.
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() {
        return this.Content || ExtensionMethods_1.StringHelper.Empty;
        //ref: //info: 
        //todo: implement arraybuffer and encoding using TextDecoder or some other tech
        // if (this.Content == null) {
        //     return StringHelper.Empty;
        // }
        // else {
        //     try {
        //         // Try to convert to original MIME content using specified charset. If this fails, 
        //         // return the Base64 representation of the content.
        //         // Note: Encoding.GetString can throw DecoderFallbackException which is a subclass
        //         // of ArgumentException.
        //         string charSet = string.IsNullOrEmpty(this.CharacterSet)
        //             ? Encoding.UTF8.EncodingName
        //             : this.CharacterSet;
        //         Encoding encoding = Encoding.GetEncoding(charSet);
        //         return encoding.GetString(this.Content);
        //     }
        //     catch (ArgumentException) {
        //         return Convert.ToBase64String(this.Content);
        //     }
        // }
    }
    toString() { return this.ToString(); }
}
exports.MimeContent = MimeContent;
//# sourceMappingURL=MimeContent.js.map