"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OccurrenceInfoCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const OccurrenceInfo_1 = require("./OccurrenceInfo");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of OccurrenceInfo objects.
 */
class OccurrenceInfoCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **OccurrenceInfoCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}   xmlElementName   Name of the XML element.
     * @return  {OccurrenceInfo}        OccurenceInfo instance.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == XmlElementNames_1.XmlElementNames.Occurrence) {
            return new OccurrenceInfo_1.OccurrenceInfo();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {OccurrenceInfo}      OccurenceInfo instance.
     */
    CreateDefaultComplexProperty() { return new OccurrenceInfo_1.OccurrenceInfo(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {OccurrenceInfo}    complexProperty   The complex property.
     * @return  {string}            XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.Occurrence; }
}
exports.OccurrenceInfoCollection = OccurrenceInfoCollection;
//# sourceMappingURL=OccurrenceInfoCollection.js.map