"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersonaPostalAddress = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const LocationSource_1 = require("../Enumerations/LocationSource");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents PersonaPostalAddress.
 */
class PersonaPostalAddress extends ComplexProperty_1.ComplexProperty {
    constructor(street, city, state, country, postalCode, postOfficeBox, locationSource, locationUri, formattedAddress, latitude, longitude, accuracy, altitude, altitudeAccuracy) {
        super();
        this.street = null;
        this.city = null;
        this.state = null;
        this.country = null;
        this.postalCode = null;
        this.postOfficeBox = null;
        this.type = null;
        this.latitude = null;
        this.longitude = null;
        this.accuracy = null;
        this.altitude = null;
        this.altitudeAccuracy = null;
        this.formattedAddress = null;
        this.uri = null;
        this.source = 0;
        if (arguments.length === 0)
            return;
        this.street = street;
        this.city = city;
        this.state = state;
        this.country = country;
        this.postalCode = postalCode;
        this.postOfficeBox = postOfficeBox;
        this.latitude = latitude;
        this.longitude = longitude;
        this.source = locationSource;
        this.uri = locationUri;
        this.formattedAddress = formattedAddress;
        this.accuracy = accuracy;
        this.altitude = altitude;
        this.altitudeAccuracy = altitudeAccuracy;
    }
    /**
     * Gets or sets the Street.
     */
    get Street() {
        return this.street;
    }
    set Street(value) {
        this.SetFieldValue({ getValue: () => this.street, setValue: (fieldValue) => { this.street = fieldValue; } }, value);
    }
    /**
     * Gets or sets the City.
     */
    get City() {
        return this.city;
    }
    set City(value) {
        this.SetFieldValue({ getValue: () => this.city, setValue: (fieldValue) => { this.city = fieldValue; } }, value);
    }
    /**
     * Gets or sets the state.
     */
    get State() {
        return this.state;
    }
    set State(value) {
        this.SetFieldValue({ getValue: () => this.state, setValue: (fieldValue) => { this.state = fieldValue; } }, value);
    }
    /**
     * Gets or sets the Country.
     */
    get Country() {
        return this.country;
    }
    set Country(value) {
        this.SetFieldValue({ getValue: () => this.country, setValue: (fieldValue) => { this.country = fieldValue; } }, value);
    }
    /**
     * Gets or sets the PostalCode.
     */
    get PostalCode() {
        return this.postalCode;
    }
    set PostalCode(value) {
        this.SetFieldValue({ getValue: () => this.postalCode, setValue: (fieldValue) => { this.postalCode = fieldValue; } }, value);
    }
    /**
     * Gets or sets the PostOfficeBox.
     */
    get PostOfficeBox() {
        return this.postOfficeBox;
    }
    set PostOfficeBox(value) {
        this.SetFieldValue({ getValue: () => this.postOfficeBox, setValue: (fieldValue) => { this.postOfficeBox = fieldValue; } }, value);
    }
    /**
     * Gets or sets the Type.
     */
    get Type() {
        return this.type;
    }
    set Type(value) {
        this.SetFieldValue({ getValue: () => this.type, setValue: (fieldValue) => { this.type = fieldValue; } }, value);
    }
    /**
     * Gets or sets the location source type.
     */
    get Source() {
        return this.source;
    }
    set Source(value) {
        this.SetFieldValue({ getValue: () => this.source, setValue: (fieldValue) => { this.source = fieldValue; } }, value);
    }
    /**
     * Gets or sets the location Uri.
     */
    get Uri() {
        return this.uri;
    }
    set Uri(value) {
        this.SetFieldValue({ getValue: () => this.uri, setValue: (fieldValue) => { this.uri = fieldValue; } }, value);
    }
    /**
     * Gets or sets a value indicating location latitude.
     */
    get Latitude() {
        return this.latitude;
    }
    set Latitude(value) {
        this.SetFieldValue({ getValue: () => this.latitude, setValue: (fieldValue) => { this.latitude = fieldValue; } }, value);
    }
    /**
     * Gets or sets a value indicating location longitude.
     */
    get Longitude() {
        return this.longitude;
    }
    set Longitude(value) {
        this.SetFieldValue({ getValue: () => this.longitude, setValue: (fieldValue) => { this.longitude = fieldValue; } }, value);
    }
    /**
     * Gets or sets the location accuracy.
     */
    get Accuracy() {
        return this.accuracy;
    }
    set Accuracy(value) {
        this.SetFieldValue({ getValue: () => this.accuracy, setValue: (fieldValue) => { this.accuracy = fieldValue; } }, value);
    }
    /**
     * Gets or sets the location altitude.
     */
    get Altitude() {
        return this.altitude;
    }
    set Altitude(value) {
        this.SetFieldValue({ getValue: () => this.altitude, setValue: (fieldValue) => { this.altitude = fieldValue; } }, value);
    }
    /**
     * Gets or sets the location altitude accuracy.
     */
    get AltitudeAccuracy() {
        return this.altitudeAccuracy;
    }
    set AltitudeAccuracy(value) {
        this.SetFieldValue({ getValue: () => this.altitudeAccuracy, setValue: (fieldValue) => { this.altitudeAccuracy = fieldValue; } }, value);
    }
    /**
     * Gets or sets the street address.
     */
    get FormattedAddress() {
        return this.formattedAddress;
    }
    set FormattedAddress(value) {
        this.SetFieldValue({ getValue: () => this.formattedAddress, setValue: (fieldValue) => { this.formattedAddress = fieldValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Street:
                    this.street = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.City:
                    this.city = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Country:
                    this.country = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.PostalCode:
                    this.postalCode = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.PostOfficeBox:
                    this.postOfficeBox = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.PostalAddressType:
                    this.type = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Latitude:
                    this.latitude = ExtensionMethods_1.Convert.toNumber(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Longitude:
                    this.longitude = ExtensionMethods_1.Convert.toNumber(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Accuracy:
                    this.accuracy = ExtensionMethods_1.Convert.toNumber(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Altitude:
                    this.altitude = ExtensionMethods_1.Convert.toNumber(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.AltitudeAccuracy:
                    this.altitudeAccuracy = ExtensionMethods_1.Convert.toNumber(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.FormattedAddress:
                    this.formattedAddress = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.LocationUri:
                    this.uri = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.LocationSource:
                    this.source = LocationSource_1.LocationSource[jsObject[key]];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Street, this.street);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.City, this.city);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.State, this.state);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Country, this.country);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.PostalCode, this.postalCode);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.PostOfficeBox, this.postOfficeBox);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.PostalAddressType, this.type);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Latitude, this.latitude);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Longitude, this.longitude);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Accuracy, this.accuracy);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Altitude, this.altitude);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.AltitudeAccuracy, this.altitudeAccuracy);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FormattedAddress, this.formattedAddress);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LocationUri, this.uri);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LocationSource, this.source);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.PersonaPostalAddress);
        this.WriteElementsToXml(writer);
        writer.WriteEndElement(); // xmlElementName
    }
}
exports.PersonaPostalAddress = PersonaPostalAddress;
//# sourceMappingURL=PersonaPostalAddress.js.map