"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneEntityCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PhoneEntity_1 = require("./PhoneEntity");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of PhoneEntity objects.
 */
class PhoneEntityCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    constructor(collection = null) {
        super();
        if (collection != null) {
            collection.forEach((suggestion) => { this.InternalAdd(suggestion); });
        }
    }
    /**
     * @internal Creates the complex property.
     *
     * @param   {string}        xmlElementName   Name of the XML element.
     * @return  {PhoneEntity}   PhoneEntity.
     */
    CreateComplexProperty(xmlElementName) { return new PhoneEntity_1.PhoneEntity(); }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {PhoneEntity}      PhoneEntity.
     */
    CreateDefaultComplexProperty() { return new PhoneEntity_1.PhoneEntity(); }
    /**
     * @internal Gets the name of the collection item XML element.
     *
     * @param   {PhoneEntity}   complexProperty   The complex property.
     * @return  {string}        XML element name.
     */
    GetCollectionItemXmlElementName(complexProperty) { return XmlElementNames_1.XmlElementNames.NlgPhone; }
}
exports.PhoneEntityCollection = PhoneEntityCollection;
//# sourceMappingURL=PhoneEntityCollection.js.map