"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhysicalAddressEntry = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const SimplePropertyBag_1 = require("../Core/SimplePropertyBag");
const LazyMember_1 = require("../Core/LazyMember");
const PhysicalAddressKey_1 = require("../Enumerations/PhysicalAddressKey");
const DictionaryEntryProperty_1 = require("./DictionaryEntryProperty");
class PhysicalAddressSchema {
    static get XmlElementNames() {
        return PhysicalAddressSchema.xmlElementNames.Member;
    }
}
PhysicalAddressSchema.Street = "Street";
PhysicalAddressSchema.City = "City";
PhysicalAddressSchema.State = "State";
PhysicalAddressSchema.CountryOrRegion = "CountryOrRegion";
PhysicalAddressSchema.PostalCode = "PostalCode";
PhysicalAddressSchema.xmlElementNames = new LazyMember_1.LazyMember(() => {
    var list = [];
    list.push("Street");
    list.push("City");
    list.push("State");
    list.push("CountryOrRegion");
    list.push("PostalCode");
    return list;
});
/**
 * PhysicalAddressEntry class
 */
class PhysicalAddressEntry extends DictionaryEntryProperty_1.DictionaryEntryProperty {
    constructor() {
        super();
        this.propertyBag = null;
        this.keyType = PhysicalAddressKey_1.PhysicalAddressKey;
        this.propertyBag = new SimplePropertyBag_1.SimplePropertyBag((key) => key);
        this.propertyBag.OnChange.push(this.PropertyBagChanged.bind(this));
    }
    get Street() {
        return this.propertyBag._getItem("Street");
    }
    set Street(value) {
        this.propertyBag._setItem("Street", value);
    }
    get City() {
        return this.propertyBag._getItem("City");
    }
    set City(value) {
        this.propertyBag._setItem("City", value);
    }
    get State() {
        return this.propertyBag._getItem("State");
    }
    set State(value) {
        this.propertyBag._setItem("State", value);
    }
    get CountryOrRegion() {
        return this.propertyBag._getItem("CountryOrRegion");
    }
    set CountryOrRegion(value) {
        this.propertyBag._setItem("CountryOrRegion", value);
    }
    get PostalCode() {
        return this.propertyBag._getItem("PostalCode");
    }
    set PostalCode(value) {
        this.propertyBag._setItem("PostalCode", value);
    }
    ClearChangeLog() { this.propertyBag.ClearChangeLog(); }
    GetFieldUri(xmlElementName) { return "contacts:PhysicalAddress:" + xmlElementName; }
    InternalToJson(service) { throw new Error("PhysicalAddressEntry.ts - InternalToJson : Not implemented."); }
    /**@internal */
    InternalWriteDeleteFieldToXml(writer, ewsObject, fieldXmlElementName) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetDeleteFieldXmlElementName());
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IndexedFieldURI);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldURI, this.GetFieldUri(fieldXmlElementName));
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldIndex, PhysicalAddressKey_1.PhysicalAddressKey[this.Key]);
        writer.WriteEndElement(); // IndexedFieldURI
        writer.WriteEndElement(); // ewsObject.GetDeleteFieldXmlElementName()
    }
    InternalWriteDeleteUpdateToJson(ewsObject, propertyName, updates /*System.Collections.Generic.List<any>*/) { throw new Error("PhysicalAddressEntry.ts - InternalWriteDeleteUpdateToJson : Not implemented."); }
    LoadFromJson(jsonProperty, service) { throw new Error("PhysicalAddressEntry.ts - LoadFromJson : Not implemented."); }
    PropertyBagChanged() { this.Changed(); }
    LoadFromXmlJsObject(jsonProperty, service) {
        this.Key = PhysicalAddressKey_1.PhysicalAddressKey[jsonProperty[XmlAttributeNames_1.XmlAttributeNames.Key]];
        this.Street = jsonProperty[XmlElementNames_1.XmlElementNames.Street];
        this.City = jsonProperty[XmlElementNames_1.XmlElementNames.City];
        this.State = jsonProperty[XmlElementNames_1.XmlElementNames.State];
        this.Street = jsonProperty[XmlElementNames_1.XmlElementNames.Street];
        this.CountryOrRegion = jsonProperty[XmlElementNames_1.XmlElementNames.CountryOrRegion];
        this.PostalCode = jsonProperty[XmlElementNames_1.XmlElementNames.PostalCode];
    }
    WriteDeleteUpdateToJson(service, ewsObject, updates /*System.Collections.Generic.List<any>*/) { throw new Error("PhysicalAddressEntry.ts - WriteDeleteUpdateToJson : Not implemented."); }
    /**@internal */
    WriteDeleteUpdateToXml(writer, ewsObject) {
        for (var xmlElementName of PhysicalAddressSchema.XmlElementNames) {
            this.InternalWriteDeleteFieldToXml(writer, ewsObject, xmlElementName);
        }
        return true;
    }
    /**@internal */
    WriteElementsToXml(writer) {
        for (var xmlElementName of PhysicalAddressSchema.XmlElementNames) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, xmlElementName, this.propertyBag._getItem(xmlElementName));
        }
    }
    WriteSetUpdateToJson(service, ewsObject, propertyDefinition, updates /*System.Collections.Generic.List<JsonObject>*/) { throw new Error("PhysicalAddressEntry.ts - WriteSetUpdateToJson : Not implemented."); }
    /**@internal */
    WriteSetUpdateToXml(writer, ewsObject, ownerDictionaryXmlElementName) {
        var fieldsToSet = [];
        for (var xmlElementName of this.propertyBag.AddedItems) {
            fieldsToSet.push(xmlElementName);
        }
        for (var xmlElementName of this.propertyBag.ModifiedItems) {
            fieldsToSet.push(xmlElementName);
        }
        for (var xmlElementName of fieldsToSet) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetSetFieldXmlElementName());
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IndexedFieldURI);
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldURI, this.GetFieldUri(xmlElementName));
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldIndex, PhysicalAddressKey_1.PhysicalAddressKey[this.Key]);
            writer.WriteEndElement(); // IndexedFieldURI
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ewsObject.GetXmlElementName());
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, ownerDictionaryXmlElementName);
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Entry);
            this.WriteAttributesToXml(writer);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, xmlElementName, this.propertyBag._getItem(xmlElementName));
            writer.WriteEndElement(); // Entry
            writer.WriteEndElement(); // ownerDictionaryXmlElementName
            writer.WriteEndElement(); // ewsObject.GetXmlElementName()
            writer.WriteEndElement(); // ewsObject.GetSetFieldXmlElementName()
        }
        for (var xmlElementName of this.propertyBag.RemovedItems) {
            this.InternalWriteDeleteFieldToXml(writer, ewsObject, xmlElementName);
        }
        return true;
    }
}
exports.PhysicalAddressEntry = PhysicalAddressEntry;
//# sourceMappingURL=PhysicalAddressEntry.js.map