"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonthlyRegenerationPattern = void 0;
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const Recurrence_IntervalPattern_1 = require("./Recurrence.IntervalPattern");
/**
 * Represents a regeneration pattern, as used with recurring tasks, where each occurrence happens a specified number of months after the previous one is completed.
 */
class MonthlyRegenerationPattern extends Recurrence_IntervalPattern_1.IntervalPattern {
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.MonthlyRegeneration;
    }
    /**
     * Gets a value indicating whether this instance is a regeneration pattern.
     *
     * @value   *true* if this instance is a regeneration pattern; otherwise, *false*.</value>
     */
    get IsRegenerationPattern() {
        return true;
    }
    constructor(startDate, interval) {
        if (arguments.length === 0) {
            super();
            return;
        }
        super(startDate, interval);
    }
}
exports.MonthlyRegenerationPattern = MonthlyRegenerationPattern;
//# sourceMappingURL=Recurrence.MonthlyRegenerationPattern.js.map