"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoEndRecurrenceRange = void 0;
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const RecurrenceRange_1 = require("./RecurrenceRange");
/**
 * @internal Represents recurrence range with no end date.
 */
class NoEndRecurrenceRange extends RecurrenceRange_1.RecurrenceRange {
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.NoEndRecurrence;
    }
    constructor(startDate = null) {
        arguments.length === 0 ? super() : super(startDate);
    }
    /**
     * @internal Setups the recurrence.
     *
     * @param   {Recurrence}   recurrence   The recurrence.
     */
    SetupRecurrence(recurrence) {
        super.SetupRecurrence(recurrence);
        recurrence.NeverEnds();
    }
}
exports.NoEndRecurrenceRange = NoEndRecurrenceRange;
//# sourceMappingURL=NoEndRecurrenceRange.js.map