"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleOperationErrorCollection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const RuleOperationError_1 = require("./RuleOperationError");
const ComplexPropertyCollection_1 = require("./ComplexPropertyCollection");
/**
 * Represents a collection of rule operation errors.
 *
 * @sealed
 */
class RuleOperationErrorCollection extends ComplexPropertyCollection_1.ComplexPropertyCollection {
    /**
     * @internal Initializes a new instance of the **RuleOperationErrorCollection** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates an RuleOperationError object from an XML element name.
     *
     * @param   {string}   xmlElementName   The XML element name from which to create the RuleOperationError object.
     * @return  {RuleOperationError}        A RuleOperationError object.
     */
    CreateComplexProperty(xmlElementName) {
        if (xmlElementName == XmlElementNames_1.XmlElementNames.RuleOperationError) {
            return new RuleOperationError_1.RuleOperationError();
        }
        else {
            return null;
        }
    }
    /**
     * @internal Creates the default complex property.
     *
     * @return  {RuleOperationError}      A RuleOperationError object.
     */
    CreateDefaultComplexProperty() {
        return new RuleOperationError_1.RuleOperationError();
    }
    /**
     * @internal Retrieves the XML element name corresponding to the provided RuleOperationError object.
     *
     * @param   {RuleOperationError}    operationError   The RuleOperationError object from which to determine the XML element name.
     * @return  {string}                The XML element name corresponding to the provided RuleOperationError object.
     */
    GetCollectionItemXmlElementName(operationError) {
        return XmlElementNames_1.XmlElementNames.RuleOperationError;
    }
}
exports.RuleOperationErrorCollection = RuleOperationErrorCollection;
//# sourceMappingURL=RuleOperationErrorCollection.js.map