"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RulePredicates = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EmailAddressCollection_1 = require("./EmailAddressCollection");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const FlaggedForAction_1 = require("../Enumerations/FlaggedForAction");
const Importance_1 = require("../Enumerations/Importance");
const RulePredicateDateRange_1 = require("./RulePredicateDateRange");
const RulePredicateSizeRange_1 = require("./RulePredicateSizeRange");
const Sensitivity_1 = require("../Enumerations/Sensitivity");
const StringList_1 = require("./StringList");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the set of conditions and exceptions available for a rule.
 *
 * @sealed
 */
class RulePredicates extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **RulePredicates** class.
     */
    constructor() {
        super();
        /**
         * The HasCategories predicate.
         */
        this.categories = null;
        /**
         * The ContainsBodyStrings predicate.
         */
        this.containsBodyStrings = null;
        /**
         * The ContainsHeaderStrings predicate.
         */
        this.containsHeaderStrings = null;
        /**
         * The ContainsRecipientStrings predicate.
         */
        this.containsRecipientStrings = null;
        /**
         * The ContainsSenderStrings predicate.
         */
        this.containsSenderStrings = null;
        /**
         * The ContainsSubjectOrBodyStrings predicate.
         */
        this.containsSubjectOrBodyStrings = null;
        /**
         * The ContainsSubjectStrings predicate.
         */
        this.containsSubjectStrings = null;
        /**
         * The FlaggedForAction predicate.
         */
        this.flaggedForAction = null; //Nullable
        /**
         * The FromAddresses predicate.
         */
        this.fromAddresses = null;
        /**
         * The FromConnectedAccounts predicate.
         */
        this.fromConnectedAccounts = null;
        /**
         * The HasAttachments predicate.
         */
        this.hasAttachments = false;
        /**
         * The Importance predicate.
         */
        this.importance = null; //Nullable
        /**
         * The IsApprovalRequest predicate.
         */
        this.isApprovalRequest = false;
        /**
         * The IsAutomaticForward predicate.
         */
        this.isAutomaticForward = false;
        /**
         * The IsAutomaticReply predicate.
         */
        this.isAutomaticReply = false;
        /**
         * The IsEncrypted predicate.
         */
        this.isEncrypted = false;
        /**
         * The IsMeetingRequest predicate.
         */
        this.isMeetingRequest = false;
        /**
         * The IsMeetingResponse predicate.
         */
        this.isMeetingResponse = false;
        /**
         * The IsNDR predicate.
         */
        this.isNonDeliveryReport = false;
        /**
         * The IsPermissionControlled predicate.
         */
        this.isPermissionControlled = false;
        /**
         * The IsSigned predicate.
         */
        this.isSigned = false;
        /**
         * The IsVoicemail predicate.
         */
        this.isVoicemail = false;
        /**
         * The IsReadReceipt predicate.
         */
        this.isReadReceipt = false;
        /**
         * The ItemClasses predicate.
         */
        this.itemClasses = null;
        /**
         * The MessageClassifications predicate.
         */
        this.messageClassifications = null;
        /**
         * The NotSentToMe predicate.
         */
        this.notSentToMe = false;
        /**
         * The SentCcMe predicate.
         */
        this.sentCcMe = false;
        /**
         * The SentOnlyToMe predicate.
         */
        this.sentOnlyToMe = false;
        /**
         * The SentToAddresses predicate.
         */
        this.sentToAddresses = null;
        /**
         * The SentToMe predicate.
         */
        this.sentToMe = false;
        /**
         * The SentToOrCcMe predicate.
         */
        this.sentToOrCcMe = false;
        /**
         * The Sensitivity predicate.
         */
        this.sensitivity = null; //Nullable
        /**
         * The WithinDateRange predicate.
         */
        this.withinDateRange = null;
        /**
         * The WithinSizeRange predicate.
         */
        this.withinSizeRange = null;
        this.categories = new StringList_1.StringList();
        this.containsBodyStrings = new StringList_1.StringList();
        this.containsHeaderStrings = new StringList_1.StringList();
        this.containsRecipientStrings = new StringList_1.StringList();
        this.containsSenderStrings = new StringList_1.StringList();
        this.containsSubjectOrBodyStrings = new StringList_1.StringList();
        this.containsSubjectStrings = new StringList_1.StringList();
        this.fromAddresses = new EmailAddressCollection_1.EmailAddressCollection(XmlElementNames_1.XmlElementNames.Address);
        this.fromConnectedAccounts = new StringList_1.StringList();
        this.itemClasses = new StringList_1.StringList();
        this.messageClassifications = new StringList_1.StringList();
        this.sentToAddresses = new EmailAddressCollection_1.EmailAddressCollection(XmlElementNames_1.XmlElementNames.Address);
        this.withinDateRange = new RulePredicateDateRange_1.RulePredicateDateRange();
        this.withinSizeRange = new RulePredicateSizeRange_1.RulePredicateSizeRange();
    }
    /**
     * Gets the categories that an incoming message should be stamped with for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get Categories() {
        return this.categories;
    }
    /**
     * Gets the strings that should appear in the body of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsBodyStrings() {
        return this.containsBodyStrings;
    }
    /**
     * Gets the strings that should appear in the headers of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsHeaderStrings() {
        return this.containsHeaderStrings;
    }
    /**
     * Gets the strings that should appear in either the To or Cc fields of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsRecipientStrings() {
        return this.containsRecipientStrings;
    }
    /**
     * Gets the strings that should appear in the From field of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsSenderStrings() {
        return this.containsSenderStrings;
    }
    /**
     * Gets the strings that should appear in either the body or the subject of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsSubjectOrBodyStrings() {
        return this.containsSubjectOrBodyStrings;
    }
    /**
     * Gets the strings that should appear in the subject of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ContainsSubjectStrings() {
        return this.containsSubjectStrings;
    }
    /**
     * @Nullable Gets or sets the flag for action value that should appear on incoming messages for the condition or execption to apply.
     * To disable this predicate, set it to null.
     */
    get FlaggedForAction() {
        return this.flaggedForAction;
    }
    set FlaggedForAction(value) {
        this.SetFieldValue({ getValue: () => this.flaggedForAction, setValue: (updateValue) => { this.flaggedForAction = updateValue; } }, value);
    }
    /**
     * Gets the e-mail addresses of the senders of incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get FromAddresses() {
        return this.fromAddresses;
    }
    /**
     * Gets or sets a value indicating whether incoming messages must have attachments for the condition or exception to apply.
     */
    get HasAttachments() {
        return this.hasAttachments;
    }
    set HasAttachments(value) {
        this.SetFieldValue({ getValue: () => this.hasAttachments, setValue: (updateValue) => { this.hasAttachments = updateValue; } }, value);
    }
    /**
     * @Nullable Gets or sets the importance that should be stamped on incoming messages for the condition or exception to apply.
     * To disable this predicate, set it to null.
     */
    get Importance() {
        return this.importance;
    }
    set Importance(value) {
        this.SetFieldValue({ getValue: () => this.importance, setValue: (updateValue) => { this.importance = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be approval requests for the condition or exception to apply.
     */
    get IsApprovalRequest() {
        return this.isApprovalRequest;
    }
    set IsApprovalRequest(value) {
        this.SetFieldValue({ getValue: () => this.isApprovalRequest, setValue: (updateValue) => { this.isApprovalRequest = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be automatic forwards for the condition or exception to apply.
     */
    get IsAutomaticForward() {
        return this.isAutomaticForward;
    }
    set IsAutomaticForward(value) {
        this.SetFieldValue({ getValue: () => this.isAutomaticForward, setValue: (updateValue) => { this.isAutomaticForward = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be automatic replies for the condition or exception to apply.
     */
    get IsAutomaticReply() {
        return this.isAutomaticReply;
    }
    set IsAutomaticReply(value) {
        this.SetFieldValue({ getValue: () => this.isAutomaticReply, setValue: (updateValue) => { this.isAutomaticReply = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be S/MIME encrypted for the condition or exception to apply.
     */
    get IsEncrypted() {
        return this.isEncrypted;
    }
    set IsEncrypted(value) {
        this.SetFieldValue({ getValue: () => this.isEncrypted, setValue: (updateValue) => { this.isEncrypted = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be meeting requests for the condition or exception to apply.
     */
    get IsMeetingRequest() {
        return this.isMeetingRequest;
    }
    set IsMeetingRequest(value) {
        this.SetFieldValue({ getValue: () => this.isMeetingRequest, setValue: (updateValue) => { this.isMeetingRequest = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be meeting responses for the condition or exception to apply.
     */
    get IsMeetingResponse() {
        return this.isMeetingResponse;
    }
    set IsMeetingResponse(value) {
        this.SetFieldValue({ getValue: () => this.isMeetingResponse, setValue: (updateValue) => { this.isMeetingResponse = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be non-delivery reports (NDR) for the condition or exception to apply.
     */
    get IsNonDeliveryReport() {
        return this.isNonDeliveryReport;
    }
    set IsNonDeliveryReport(value) {
        this.SetFieldValue({ getValue: () => this.isNonDeliveryReport, setValue: (updateValue) => { this.isNonDeliveryReport = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be permission controlled (RMS protected) for the condition or exception to apply.
     */
    get IsPermissionControlled() {
        return this.isPermissionControlled;
    }
    set IsPermissionControlled(value) {
        this.SetFieldValue({ getValue: () => this.isPermissionControlled, setValue: (updateValue) => { this.isPermissionControlled = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be S/MIME signed for the condition or exception to apply.
     */
    get IsSigned() {
        return this.isSigned;
    }
    set IsSigned(value) {
        this.SetFieldValue({ getValue: () => this.isSigned, setValue: (updateValue) => { this.isSigned = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be voice mails for the condition or exception to apply.
     */
    get IsVoicemail() {
        return this.isVoicemail;
    }
    set IsVoicemail(value) {
        this.SetFieldValue({ getValue: () => this.isVoicemail, setValue: (updateValue) => { this.isVoicemail = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether incoming messages must be read receipts for the condition or exception to apply.
     */
    get IsReadReceipt() {
        return this.isReadReceipt;
    }
    set IsReadReceipt(value) {
        this.SetFieldValue({ getValue: () => this.isReadReceipt, setValue: (updateValue) => { this.isReadReceipt = updateValue; } }, value);
    }
    /**
     * Gets the e-mail account names from which incoming messages must have been aggregated for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get FromConnectedAccounts() {
        return this.fromConnectedAccounts;
    }
    /**
     * Gets the item classes that must be stamped on incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get ItemClasses() {
        return this.itemClasses;
    }
    /**
     * Gets the message classifications that must be stamped on incoming messages for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get MessageClassifications() {
        return this.messageClassifications;
    }
    /**
     * Gets or sets a value indicating whether the owner of the mailbox must NOT be a To recipient of the incoming messages for the condition or exception to apply.
     */
    get NotSentToMe() {
        return this.notSentToMe;
    }
    set NotSentToMe(value) {
        this.SetFieldValue({ getValue: () => this.notSentToMe, setValue: (updateValue) => { this.notSentToMe = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether the owner of the mailbox must be a Cc recipient of incoming messages for the condition or exception to apply.
     */
    get SentCcMe() {
        return this.sentCcMe;
    }
    set SentCcMe(value) {
        this.SetFieldValue({ getValue: () => this.sentCcMe, setValue: (updateValue) => { this.sentCcMe = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether the owner of the mailbox must be the only To recipient of incoming messages for the condition or exception to apply.
     */
    get SentOnlyToMe() {
        return this.sentOnlyToMe;
    }
    set SentOnlyToMe(value) {
        this.SetFieldValue({ getValue: () => this.sentOnlyToMe, setValue: (updateValue) => { this.sentOnlyToMe = updateValue; } }, value);
    }
    /**
     * Gets the e-mail addresses incoming messages must have been sent to for the condition or exception to apply.
     * To disable this predicate, empty the list.
     */
    get SentToAddresses() {
        return this.sentToAddresses;
    }
    /**
     * Gets or sets a value indicating whether the owner of the mailbox must be a To recipient of incoming messages for the condition or exception to apply.
     */
    get SentToMe() {
        return this.sentToMe;
    }
    set SentToMe(value) {
        this.SetFieldValue({ getValue: () => this.sentToMe, setValue: (updateValue) => { this.sentToMe = updateValue; } }, value);
    }
    /**
     * Gets or sets a value indicating whether the owner of the mailbox must be either a To or Cc recipient of incoming messages for the condition or exception to apply.
     */
    get SentToOrCcMe() {
        return this.sentToOrCcMe;
    }
    set SentToOrCcMe(value) {
        this.SetFieldValue({ getValue: () => this.sentToOrCcMe, setValue: (updateValue) => { this.sentToOrCcMe = updateValue; } }, value);
    }
    /**
     * @Nullable Gets or sets the sensitivity that must be stamped on incoming messages for the condition or exception to apply.
     * To disable this predicate, set it to null.
     */
    get Sensitivity() {
        return this.sensitivity;
    }
    set Sensitivity(value) {
        this.SetFieldValue({ getValue: () => this.sensitivity, setValue: (updateValue) => { this.sensitivity = updateValue; } }, value);
    }
    /**
     * Gets the date range within which incoming messages must have been received for the condition or exception to apply.
     * To disable this predicate, set both its Start and End properties to null.
     */
    get WithinDateRange() {
        return this.withinDateRange;
    }
    /**
     * Gets the minimum and maximum sizes incoming messages must have for the condition or exception to apply.
     * To disable this predicate, set both its MinimumSize and MaximumSize properties to null.
     */
    get WithinSizeRange() {
        return this.withinSizeRange;
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        super.InternalValidate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.fromAddresses, "FromAddresses");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.sentToAddresses, "SentToAddresses");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.withinDateRange, "WithinDateRange");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.withinSizeRange, "WithinSizeRange");
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Categories:
                    this.categories.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsBodyStrings:
                    this.containsBodyStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsHeaderStrings:
                    this.containsHeaderStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsRecipientStrings:
                    this.containsRecipientStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsSenderStrings:
                    this.containsSenderStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsSubjectOrBodyStrings:
                    this.containsSubjectOrBodyStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.ContainsSubjectStrings:
                    this.containsSubjectStrings.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.FlaggedForAction:
                    this.flaggedForAction = FlaggedForAction_1.FlaggedForAction[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.FromAddresses:
                    this.fromAddresses.CreateFromXmlJsObjectCollection(jsObject[key][XmlElementNames_1.XmlElementNames.Address], service);
                    break;
                case XmlElementNames_1.XmlElementNames.FromConnectedAccounts:
                    this.fromConnectedAccounts.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.HasAttachments:
                    this.hasAttachments = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Importance:
                    this.importance = Importance_1.Importance[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.IsApprovalRequest:
                    this.isApprovalRequest = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsAutomaticForward:
                    this.isAutomaticForward = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsAutomaticReply:
                    this.isAutomaticReply = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsEncrypted:
                    this.isEncrypted = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsMeetingRequest:
                    this.isMeetingRequest = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsMeetingResponse:
                    this.isMeetingResponse = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsNDR:
                    this.isNonDeliveryReport = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsPermissionControlled:
                    this.isPermissionControlled = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsSigned:
                    this.isSigned = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsVoicemail:
                    this.isVoicemail = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsReadReceipt:
                    this.isReadReceipt = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.ItemClasses:
                    this.itemClasses.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.MessageClassifications:
                    this.messageClassifications.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NotSentToMe:
                    this.notSentToMe = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.SentCcMe:
                    this.sentCcMe = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.SentOnlyToMe:
                    this.sentOnlyToMe = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.SentToAddresses:
                    this.sentToAddresses.CreateFromXmlJsObjectCollection(jsObject[key][XmlElementNames_1.XmlElementNames.Address], service);
                    break;
                case XmlElementNames_1.XmlElementNames.SentToMe:
                    this.sentToMe = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.SentToOrCcMe:
                    this.sentToOrCcMe = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Sensitivity:
                    this.sensitivity = Sensitivity_1.Sensitivity[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.WithinDateRange:
                    this.withinDateRange.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.WithinSizeRange:
                    this.withinSizeRange.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if (this.Categories.Count > 0) {
            this.Categories.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Categories);
        }
        if (this.ContainsBodyStrings.Count > 0) {
            this.ContainsBodyStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsBodyStrings);
        }
        if (this.ContainsHeaderStrings.Count > 0) {
            this.ContainsHeaderStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsHeaderStrings);
        }
        if (this.ContainsRecipientStrings.Count > 0) {
            this.ContainsRecipientStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsRecipientStrings);
        }
        if (this.ContainsSenderStrings.Count > 0) {
            this.ContainsSenderStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsSenderStrings);
        }
        if (this.ContainsSubjectOrBodyStrings.Count > 0) {
            this.ContainsSubjectOrBodyStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsSubjectOrBodyStrings);
        }
        if (this.ContainsSubjectStrings.Count > 0) {
            this.ContainsSubjectStrings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ContainsSubjectStrings);
        }
        if ((0, ExtensionMethods_1.hasValue)(this.FlaggedForAction)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FlaggedForAction, FlaggedForAction_1.FlaggedForAction[this.FlaggedForAction]);
        }
        if (this.FromAddresses.Count > 0) {
            this.FromAddresses.WriteToXml(writer, XmlElementNames_1.XmlElementNames.FromAddresses);
        }
        if (this.FromConnectedAccounts.Count > 0) {
            this.FromConnectedAccounts.WriteToXml(writer, XmlElementNames_1.XmlElementNames.FromConnectedAccounts);
        }
        if (this.HasAttachments != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.HasAttachments, this.HasAttachments);
        }
        if ((0, ExtensionMethods_1.hasValue)(this.Importance)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Importance, Importance_1.Importance[this.Importance]);
        }
        if (this.IsApprovalRequest != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsApprovalRequest, this.IsApprovalRequest);
        }
        if (this.IsAutomaticForward != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsAutomaticForward, this.IsAutomaticForward);
        }
        if (this.IsAutomaticReply != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsAutomaticReply, this.IsAutomaticReply);
        }
        if (this.IsEncrypted != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsEncrypted, this.IsEncrypted);
        }
        if (this.IsMeetingRequest != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsMeetingRequest, this.IsMeetingRequest);
        }
        if (this.IsMeetingResponse != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsMeetingResponse, this.IsMeetingResponse);
        }
        if (this.IsNonDeliveryReport != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsNDR, this.IsNonDeliveryReport);
        }
        if (this.IsPermissionControlled != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsPermissionControlled, this.IsPermissionControlled);
        }
        if (this.isReadReceipt != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsReadReceipt, this.IsReadReceipt);
        }
        if (this.IsSigned != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsSigned, this.IsSigned);
        }
        if (this.IsVoicemail != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.IsVoicemail, this.IsVoicemail);
        }
        if (this.ItemClasses.Count > 0) {
            this.ItemClasses.WriteToXml(writer, XmlElementNames_1.XmlElementNames.ItemClasses);
        }
        if (this.MessageClassifications.Count > 0) {
            this.MessageClassifications.WriteToXml(writer, XmlElementNames_1.XmlElementNames.MessageClassifications);
        }
        if (this.NotSentToMe != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.NotSentToMe, this.NotSentToMe);
        }
        if (this.SentCcMe != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SentCcMe, this.SentCcMe);
        }
        if (this.SentOnlyToMe != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SentOnlyToMe, this.SentOnlyToMe);
        }
        if (this.SentToAddresses.Count > 0) {
            this.SentToAddresses.WriteToXml(writer, XmlElementNames_1.XmlElementNames.SentToAddresses);
        }
        if (this.SentToMe != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SentToMe, this.SentToMe);
        }
        if (this.SentToOrCcMe != false) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SentToOrCcMe, this.SentToOrCcMe);
        }
        if ((0, ExtensionMethods_1.hasValue)(this.Sensitivity)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Sensitivity, Sensitivity_1.Sensitivity[this.Sensitivity]);
        }
        if (this.WithinDateRange.Start || this.WithinDateRange.End) {
            this.WithinDateRange.WriteToXml(writer, XmlElementNames_1.XmlElementNames.WithinDateRange);
        }
        if (this.WithinSizeRange.MaximumSize || this.WithinSizeRange.MinimumSize) {
            this.WithinSizeRange.WriteToXml(writer, XmlElementNames_1.XmlElementNames.WithinSizeRange);
        }
    }
}
exports.RulePredicates = RulePredicates;
//# sourceMappingURL=RulePredicates.js.map