"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetRuleOperation = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const Rule_1 = require("./Rule");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const RuleOperation_1 = require("./RuleOperation");
/**
 * Represents an operation to update an existing rule.
 *
 * @sealed
 */
class SetRuleOperation extends RuleOperation_1.RuleOperation {
    constructor(rule = null) {
        super();
        this.rule = rule;
    }
    /**
     * Gets or sets the rule to be updated.
     */
    get Rule() {
        return this.rule;
    }
    set Rule(value) {
        this.SetFieldValue({ getValue: () => this.rule, setValue: (updateValue) => { this.rule = updateValue; } }, value);
    }
    /**
     * @internal Gets the Xml element name of the SetRuleOperation object.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.SetRuleOperation;
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.rule, "Rule");
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Rule:
                    this.rule = new Rule_1.Rule();
                    this.rule.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        this.Rule.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Rule);
    }
}
exports.SetRuleOperation = SetRuleOperation;
//# sourceMappingURL=SetRuleOperation.js.map