"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeChangeRecurrence = void 0;
const DayOfTheWeek_1 = require("../Enumerations/DayOfTheWeek");
const DayOfTheWeekIndex_1 = require("../Enumerations/DayOfTheWeekIndex");
const ExtensionMethods_1 = require("../ExtensionMethods");
const Month_1 = require("../Enumerations/Month");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * @internal Represents a recurrence pattern for a time change in a time zone.
 * @sealed
 */
class TimeChangeRecurrence extends ComplexProperty_1.ComplexProperty {
    constructor(dayOfTheWeekIndex = null, dayOfTheWeek = null, month = null) {
        super();
        this.dayOfTheWeekIndex = dayOfTheWeekIndex;
        this.dayOfTheWeek = dayOfTheWeek;
        this.month = month;
    }
    /**
     * Gets or sets the index of the day in the month at which the time change occurs.
     */
    get DayOfTheWeekIndex() {
        return this.dayOfTheWeekIndex;
    }
    set DayOfTheWeekIndex(value) {
    }
    /**
     * Gets or sets the day of the week the time change occurs.
     */
    get DayOfTheWeek() {
        return this.dayOfTheWeek;
    }
    set DayOfTheWeek(value) {
    }
    /**
     * Gets or sets the month the time change occurs.
     */
    get Month() {
        return this.month;
    }
    set Month(value) {
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsonProperty, service) {
        for (let key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.DaysOfWeek:
                    this.dayOfTheWeek = DayOfTheWeek_1.DayOfTheWeek[jsonProperty[key]];
                case XmlElementNames_1.XmlElementNames.DayOfWeekIndex:
                    this.dayOfTheWeekIndex = DayOfTheWeekIndex_1.DayOfTheWeekIndex[jsonProperty[key]];
                case XmlElementNames_1.XmlElementNames.Month:
                    this.month = Month_1.Month[jsonProperty[key]];
                default:
            }
        }
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if ((0, ExtensionMethods_1.hasValue)(this.DayOfTheWeek)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DaysOfWeek, this.DayOfTheWeek);
        }
        if ((0, ExtensionMethods_1.hasValue)(this.dayOfTheWeekIndex)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DayOfWeekIndex, this.DayOfTheWeekIndex);
        }
        if (this.Month) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Month, this.Month);
        }
    }
}
exports.TimeChangeRecurrence = TimeChangeRecurrence;
//# sourceMappingURL=TimeChangeRecurrence.js.map