"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbsoluteDateTransition = void 0;
const DateTime_1 = require("../../DateTime");
const ServiceLocalException_1 = require("../../Exceptions/ServiceLocalException");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const TimeZoneTransition_1 = require("./TimeZoneTransition");
/**
 * @internal Represents a time zone period transition that occurs on a fixed (absolute) date.
 */
class AbsoluteDateTransition extends TimeZoneTransition_1.TimeZoneTransition {
    constructor(timeZoneDefinition, targetGroup) {
        super(timeZoneDefinition, targetGroup);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.AbsoluteDateTransition;
    }
    /**
     * @internal Initializes this transition based on the specified transition time.
     *
     * @param   {TimeZoneInfo.TransitionTime}   transitionTime   The transition time to initialize from.
     */
    InitializeFromTransitionTime(transitionTime) {
        throw new ServiceLocalException_1.ServiceLocalException(Strings_1.Strings.UnsupportedTimeZonePeriodTransitionTarget);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        if (jsObject[XmlElementNames_1.XmlElementNames.DateTime]) {
            this.DateTime = DateTime_1.DateTime.Parse(jsObject[XmlElementNames_1.XmlElementNames.DateTime]);
        }
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DateTime, this.DateTime);
    }
}
exports.AbsoluteDateTransition = AbsoluteDateTransition;
//# sourceMappingURL=AbsoluteDateTransition.js.map