"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UniqueBody = void 0;
const BodyType_1 = require("../Enumerations/BodyType");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the body part of an item that is unique to the conversation the item is part of.
 */
class UniqueBody extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **UniqueBody** class.
     */
    constructor() {
        super();
        this.bodyType = BodyType_1.BodyType.HTML;
        this.text = null;
        this.isTruncated = false;
    }
    /**
     * Gets the type of the normalized body's text.
     */
    get BodyType() {
        return this.bodyType;
    }
    /**
     * Gets the text of the normalized body.
     */
    get Text() {
        return this.text;
    }
    /**
     * Gets whether the body is truncated.
     */
    get IsTruncated() {
        return this.isTruncated;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.BodyType:
                    this.bodyType = BodyType_1.BodyType[jsObject[key]];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.IsTruncated:
                    this.isTruncated = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.UniqueBody:
                    this.text = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * Returns a **String** that represents the current **Object**.
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() { return this.Text || ExtensionMethods_1.StringHelper.Empty; }
    toString() { return this.ToString(); }
    /**
     * @internal Writes attributes to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.BodyType, this.BodyType);
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Text)) {
            writer.WriteValue(this.Text, XmlElementNames_1.XmlElementNames.UniqueBody);
        }
    }
}
exports.UniqueBody = UniqueBody;
//# sourceMappingURL=UniqueBody.js.map