"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an UrlEntity object.
 */
class UrlEntity extends ExtractedEntity_1.ExtractedEntity {
    /**
     * Initializes a new instance of the **UrlEntity** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgUrl:
                    this.Url = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.UrlEntity = UrlEntity;
//# sourceMappingURL=UrlEntity.js.map