"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserId = void 0;
const StandardUser_1 = require("../Enumerations/StandardUser");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the Id of a user.
 *
 * @sealed
 */
class UserId extends ComplexProperty_1.ComplexProperty {
    constructor(primarySmtpAddressOrStandardUser) {
        super();
        this.sID = null;
        this.primarySmtpAddress = null;
        this.displayName = null;
        this.standardUser = null;
        if (typeof primarySmtpAddressOrStandardUser !== 'undefined') {
            if (typeof primarySmtpAddressOrStandardUser === 'string') {
                this.primarySmtpAddress = primarySmtpAddressOrStandardUser;
            }
            else {
                this.standardUser = primarySmtpAddressOrStandardUser;
            }
        }
    }
    /**
     * Gets or sets the SID of the user.
     */
    get SID() {
        return this.sID;
    }
    set SID(value) {
        this.SetFieldValue({ getValue: () => this.sID, setValue: (data) => this.sID = data }, value);
    }
    /**
     * Gets or sets the primary SMTP address or the user.
     */
    get PrimarySmtpAddress() {
        return this.primarySmtpAddress;
    }
    set PrimarySmtpAddress(value) {
        this.SetFieldValue({ getValue: () => this.primarySmtpAddress, setValue: (data) => this.primarySmtpAddress = data }, value);
    }
    /**
     * Gets or sets the display name of the user.
     */
    get DisplayName() {
        return this.displayName;
    }
    set DisplayName(value) {
        this.SetFieldValue({ getValue: () => this.displayName, setValue: (data) => this.displayName = data }, value);
    }
    /**
     * Gets or sets a value indicating which standard user the user represents.
     *
     * @Nullable
     */
    get StandardUser() {
        return this.standardUser;
    }
    set StandardUser(value) {
        this.SetFieldValue({ getValue: () => this.standardUser, setValue: (data) => this.standardUser = data }, value);
    }
    /**
     * @internal Determines whether this instance is valid.
     *
     * @return  {boolean}      true if this instance is valid; otherwise, false.
     */
    IsValid() {
        return typeof this.StandardUser === 'number' || !ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.PrimarySmtpAddress) || !ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.SID);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (var key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.SID:
                    this.sID = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.PrimarySmtpAddress:
                    this.primarySmtpAddress = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.DisplayName:
                    this.displayName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.DistinguishedUser:
                    //debugger;//check for enum value consistency
                    this.standardUser = StandardUser_1.StandardUser[jsObject[key]];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SID, this.SID);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.PrimarySmtpAddress, this.PrimarySmtpAddress);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DisplayName, this.DisplayName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DistinguishedUser, StandardUser_1.StandardUser[this.StandardUser]);
    }
}
exports.UserId = UserId;
//# sourceMappingURL=UserId.js.map