"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VotingInformation = void 0;
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const VotingOptionData_1 = require("./VotingOptionData");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents voting information.
 * @sealed
 */
class VotingInformation extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **VotingInformation** class.
     */
    constructor() {
        super();
        this.userOptions = [];
        this.votingResponse = null;
    }
    /**
     * Gets the list of user options.
     */
    get UserOptions() {
        return this.userOptions;
    }
    /**
     * Gets the voting response.
     */
    get VotingResponse() {
        return this.votingResponse;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.UserOptions]) {
            let votingOptionObjects = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject, XmlElementNames_1.XmlElementNames.UserOptions);
            for (let votingOptionObject of votingOptionObjects) {
                let option = new VotingOptionData_1.VotingOptionData();
                option.LoadFromXmlJsObject(votingOptionObject, service);
                this.userOptions.push(option);
            }
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.VotingResponse]) {
            this.votingResponse = jsObject[XmlElementNames_1.XmlElementNames.VotingResponse];
        }
    }
}
exports.VotingInformation = VotingInformation;
//# sourceMappingURL=VotingInformation.js.map