"use strict";
//todo: ix this - import Xml = require("System.Xml");
Object.defineProperty(exports, "__esModule", { value: true });
exports.EwsXmlReader = void 0;
const EwsUtilities_1 = require("./EwsUtilities");
const EwsLogging_1 = require("./EwsLogging");
const ExtensionMethods_1 = require("../ExtensionMethods");
/** @internal */
class EwsXmlReader {
    //#endregion
    //#region Constructor
    constructor(rawXML) {
        this.eof = false;
        var parser = new ExtensionMethods_1.DOMParser();
        this.xmlDoc = parser.parseFromString(rawXML, "text/xml");
        //this.treeWalker = this.xmlDoc.createTreeWalker(this.xmlDoc, NodeFilter.SHOW_ELEMENT, null, false);
        //this.currentNode = this.treeWalker.root;
        var xml2js = new ExtensionMethods_1.xml2JsObject();
        this.jsObject = xml2js.parseXMLNode(this.xmlDoc.documentElement, true);
        EwsLogging_1.EwsLogging.DebugLog(this.JsObject, true);
    }
    get HasAttributes() { return this.currentNode ? this.currentNode.hasAttributes() : false; }
    get IsEmptyElement() { return this.currentNode.nodeType == Node.ELEMENT_NODE /*System.Xml.XmlNodeType.Element*/ && !this.currentNode.hasChildNodes(); }
    get LocalName() { return this.currentNode ? this.currentNode.localName : undefined; }
    get NamespacePrefix() { return this.currentNode ? this.currentNode.prefix : undefined; }
    get NamespaceUri() { return this.currentNode ? this.currentNode.namespaceURI : undefined; }
    get NodeType() { return this.currentNode ? this.currentNode.nodeType : undefined; }
    //get PrevNodeType(): System.Xml.XmlNodeType { return this.prevNodeType; }
    get IsRoot() { return this.currentNode == this.treeWalker.root; }
    get ParentNode() { return this.currentNode ? this.currentNode.parentNode : undefined; }
    get CurrentNode() { return this.currentNode; }
    get Eof() { return this.eof; }
    //#region xml2JS logic
    get JsObject() { return this.jsObject; }
    //#endregion
    EnsureCurrentNodeIsEndElement(xmlNamespace, localName) { throw new Error("EwsXmlReader.ts - EnsureCurrentNodeIsEndElement : Not implemented."); }
    //EnsureCurrentNodeIsStartElement(xmlNamespace: XmlNamespace, localName: string): any { throw new Error("EwsXmlReader.ts - EnsureCurrentNodeIsStartElement : Not implemented."); }
    //EnsureCurrentNodeIsStartElement(): any { throw new Error("EwsXmlReader.ts - EnsureCurrentNodeIsStartElement : Not implemented."); }
    FormatElementName(namespacePrefix, localElementName) { throw new Error("EwsXmlReader.ts - FormatElementName : Not implemented."); }
    GetXmlReaderForNode() { throw new Error("EwsXmlReader.ts - GetXmlReaderForNode : Not implemented."); }
    InitializeXmlReader(stream /*System.IO.Stream*/) { throw new Error("EwsXmlReader.ts - InitializeXmlReader : Not implemented."); }
    //InternalReadElement(namespacePrefix: string, localName: string, nodeType: System.Xml.XmlNodeType): any;// { throw new Error("EwsXmlReader.ts - InternalReadElement : Not implemented."); }
    InternalReadElement(xmlNamespace, localName, nodeType /*Xml.XmlNodeType*/) {
        if (this.LocalName === localName && this.NamespaceUri == EwsUtilities_1.EwsUtilities.GetNamespaceUri(xmlNamespace))
            return;
        this.Read(nodeType);
        if (localName && nodeType)
            if ((this.LocalName != localName) || (this.NamespaceUri != EwsUtilities_1.EwsUtilities.GetNamespaceUri(xmlNamespace))) {
                throw new Error(ExtensionMethods_1.StringHelper.Format("unexpected element, {0}:{1}, {2}, {3}, {4}", EwsUtilities_1.EwsUtilities.GetNamespacePrefix(xmlNamespace), localName, nodeType, this.xmlReader.Name, this.NodeType));
            }
    }
    HasRecursiveParent(localName, node = this.currentNode) {
        if (node === null || node.parentNode === null)
            return false;
        if (node.parentNode.localName == localName)
            return true;
        else
            return this.HasRecursiveParent(localName, node.parentNode);
    }
    HasRecursiveParentNode(parentNode, parentName, node = this.currentNode) {
        if (node === null || node.parentNode === null)
            return false;
        if (node.parentNode.localName == parentName && node.parentNode != parentNode)
            return false;
        if (node.parentNode == parentNode)
            return true;
        else
            return this.HasRecursiveParentNode(parentNode, parentName, node.parentNode);
    }
    //IsEndElement(xmlNamespace: XmlNamespace, localName: string): boolean { throw new Error("EwsXmlReader.ts - IsEndElement : Not implemented."); }
    //IsEndElement(namespacePrefix: string, localName: string): boolean { throw new Error("EwsXmlReader.ts - IsEndElement : Not implemented."); }
    //IsStartElement(namespacePrefix: string, localName: string): boolean { throw new Error("EwsXmlReader.ts - IsStartElement : Not implemented."); }
    //IsStartElement(): boolean { throw new Error("EwsXmlReader.ts - IsStartElement : Not implemented."); }
    //IsStartElement(xmlNamespace: XmlNamespace, localName: string): boolean { throw new Error("EwsXmlReader.ts - IsStartElement : Not implemented."); }
    IsElement(xmlNamespace, localName) {
        return (this.LocalName == localName) &&
            ((this.NamespacePrefix == EwsUtilities_1.EwsUtilities.GetNamespacePrefix(xmlNamespace)) ||
                (this.NamespaceUri == EwsUtilities_1.EwsUtilities.GetNamespaceUri(xmlNamespace)));
    }
    //Read(): any { throw new Error("EwsXmlReader.ts - Read : Not implemented."); }
    Read(nodeType /*Xml.XmlNodeType*/) {
        this.currentNode = this.treeWalker.nextNode();
        if (this.currentNode == null)
            this.eof = true;
        if (nodeType) {
            if (this.NodeType !== nodeType)
                throw new Error("unexpected element type");
        }
        return this.currentNode != null;
    }
    //ReadAttributeValue(attributeName: string): string;// { throw new Error("EwsXmlReader.ts - ReadAttributeValue : Not implemented."); }
    //ReadAttributeValue(attributeName: string): any { throw new Error("EwsXmlReader.ts - ReadAttributeValue : Not implemented."); }
    ReadAttributeValue(xmlNamespace, attributeName) {
        if (this.currentNode == null || this.currentNode.nodeType != this.currentNode.ELEMENT_NODE || !this.currentNode.hasAttributes())
            return null;
        var elem = this.currentNode;
        var val = elem.getAttributeNS(EwsUtilities_1.EwsUtilities.GetNamespaceUri(xmlNamespace), attributeName);
        return val;
    }
    //ReadBase64ElementValue(outputStream: System.IO.Stream): any { throw new Error("EwsXmlReader.ts - ReadBase64ElementValue : Not implemented."); }
    ReadBase64ElementValue() { throw new Error("EwsXmlReader.ts - ReadBase64ElementValue : Not implemented."); }
    ReadElementValue() {
        return this.currentNode.textContent;
    }
    //ReadElementValue(): any { throw new Error("EwsXmlReader.ts - ReadElementValue : Not implemented."); }
    //ReadElementValue(xmlNamespace: XmlNamespace, localName: string): any { throw new Error("EwsXmlReader.ts - ReadElementValue : Not implemented."); }
    //ReadElementValue(namespacePrefix: string, localName: string): string { throw new Error("EwsXmlReader.ts - ReadElementValue : Not implemented."); }
    //ReadElementValue(xmlNamespace: XmlNamespace, localName: string): string { throw new Error("EwsXmlReader.ts - ReadElementValue : Not implemented."); }
    //ReadEndElement(namespacePrefix: string, elementName: string): any { throw new Error("EwsXmlReader.ts - ReadEndElement : Not implemented."); }
    ReadEndElement(xmlNamespace, localName) {
        this.InternalReadElement(xmlNamespace, localName, Node.ELEMENT_NODE /*System.Xml.XmlNodeType.Element*/);
    }
    ReadEndElementIfNecessary(xmlNamespace, localName) {
        if (!(this.IsElement(xmlNamespace, localName) && this.IsEmptyElement)) {
            //if (!this.IsEndElement(xmlNamespace, localName)) {
            this.ReadEndElement(xmlNamespace, localName);
            //}
        }
    }
    ReadInnerXml() { throw new Error("EwsXmlReader.ts - ReadInnerXml : Not implemented."); }
    ReadNullableAttributeValue(attributeName) { throw new Error("EwsXmlReader.ts - ReadNullableAttributeValue : Not implemented."); }
    ReadOuterXml() { throw new Error("EwsXmlReader.ts - ReadOuterXml : Not implemented."); }
    //ReadStartElement(namespacePrefix: string, localName: string): any { throw new Error("EwsXmlReader.ts - ReadStartElement : Not implemented."); }
    ReadStartElement(xmlNamespace, localName) {
        this.InternalReadElement(xmlNamespace, localName, Node.ELEMENT_NODE /*System.Xml.XmlNodeType.Element*/);
    }
    ReadToDescendant(xmlNamespace, localName) { throw new Error("EwsXmlReader.ts - ReadToDescendant : Not implemented."); }
    ReadValue() { throw new Error("EwsXmlReader.ts - ReadValue : Not implemented."); }
    //ReadValue(): any { throw new Error("EwsXmlReader.ts - ReadValue : Not implemented."); }
    SeekLast() {
        if (!this.eof)
            this.currentNode = this.treeWalker.previousNode();
    }
    SkipCurrentElement() {
        //debug:
        var parentNode = this.CurrentNode;
        do {
            this.Read();
        } while (this.HasRecursiveParentNode(parentNode, parentNode.localName));
        this.SeekLast();
    }
    SkipElement(xmlNamespace, localName) { throw new Error("EwsXmlReader.ts - SkipElement : Not implemented."); }
    //SkipElement(namespacePrefix: string, localName: string): any { throw new Error("EwsXmlReader.ts - SkipElement : Not implemented."); }
    TryReadValue(value) { throw new Error("EwsXmlReader.ts - TryReadValue : Not implemented."); }
}
exports.EwsXmlReader = EwsXmlReader;
EwsXmlReader.ReadWriteBufferSize = 4096;
//# sourceMappingURL=EwsXmlReader.js.map