"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplyConversationActionRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a request to a Apply Conversation Action operation
 *
 * @sealed
 */
class ApplyConversationActionRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **ApplyConversationActionRequest** class.
     *
     * @param   {ExchangeService}       service   The service.
     * @param   {ServiceErrorHandling}  errorHandlingMode   Indicates how errors should be handled.
     */
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.conversationActions = [];
    }
    get ConversationActions() {
        return this.conversationActions;
    }
    /**
     * @internal Creates service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {ServiceResponse}	Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new ServiceResponse_1.ServiceResponse();
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return this.conversationActions.length;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010_SP1;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.ApplyConversationActionResponseMessage; }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.ApplyConversationActionResponse; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.ApplyConversationAction; }
    /**
     * @internal Validate the request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParamCollection(this.conversationActions, "conversationActions");
        for (let iAction = 0; iAction < this.ConversationActions.length; iAction++) {
            this.ConversationActions[iAction].Validate();
        }
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ConversationActions);
        for (let iAction = 0; iAction < this.ConversationActions.length; iAction++) {
            this.ConversationActions[iAction].WriteElementsToXml(writer);
        }
        writer.WriteEndElement();
    }
}
exports.ApplyConversationActionRequest = ApplyConversationActionRequest;
//# sourceMappingURL=ApplyConversationActionRequest.js.map